/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt9xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field12;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT973
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT973.class.getName());
    public static final String NAME = "973";
    @Deprecated
    public static final String _971 = "971";
    @Deprecated
    public static final String _972 = "972";
    @Deprecated
    public static final String _998 = "998";

    public MT973(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT973(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT973 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT973(m.message());
    }

    public MT973() {
        this("TESTUS00", "TESTUS00");
    }

    public MT973(String sender, String receiver) {
        super(973, sender, receiver);
    }

    @Deprecated
    public MT973(int messageType, String sender, String receiver) {
        super(973, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT973(int, String, String)", "Use the constructor MT973(sender, receiver) instead.");
    }

    public MT973(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT973.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT973 object from FIN content with a Service Message. Check if the MT973 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT973 object from FIN content with message type " + param.getType());
        }
    }

    public static MT973 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT973(fin);
    }

    public MT973(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT973 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT973(stream);
    }

    public MT973(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT973 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT973(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT973 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT973 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT973 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public List<Field12> getField12() {
        ArrayList<Field12> result = new ArrayList<Field12>();
        Tag[] tags = this.tags("12");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field12(tags[i].getValue()));
        }
        return result;
    }

    public List<Field25> getField25() {
        ArrayList<Field25> result = new ArrayList<Field25>();
        Tag[] tags = this.tags("25");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field25(tags[i].getValue()));
        }
        return result;
    }
}

