/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt7xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field33A;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57B;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field73;
import com.prowidesoftware.swift.model.field.Field77B;
import com.prowidesoftware.swift.model.field.Field77J;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT734
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT734.class.getName());
    public static final String NAME = "734";

    public MT734(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT734(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT734 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT734(m.message());
    }

    public MT734() {
        this("TESTUS00", "TESTUS00");
    }

    public MT734(String sender, String receiver) {
        super(734, sender, receiver);
    }

    @Deprecated
    public MT734(int messageType, String sender, String receiver) {
        super(734, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT734(int, String, String)", "Use the constructor MT734(sender, receiver) instead.");
    }

    public MT734(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT734.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT734 object from FIN content with a Service Message. Check if the MT734 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT734 object from FIN content with message type " + param.getType());
        }
    }

    public static MT734 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT734(fin);
    }

    public MT734(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT734 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT734(stream);
    }

    public MT734(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT734 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT734(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT734 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT734 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT734 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field32A getField32A() {
        Tag t = this.tag("32A");
        if (t != null) {
            return new Field32A(t.getValue());
        }
        return null;
    }

    public Field73 getField73() {
        Tag t = this.tag("73");
        if (t != null) {
            return new Field73(t.getValue());
        }
        return null;
    }

    public Field33A getField33A() {
        Tag t = this.tag("33A");
        if (t != null) {
            return new Field33A(t.getValue());
        }
        return null;
    }

    public Field33B getField33B() {
        Tag t = this.tag("33B");
        if (t != null) {
            return new Field33B(t.getValue());
        }
        return null;
    }

    public Field57A getField57A() {
        Tag t = this.tag("57A");
        if (t != null) {
            return new Field57A(t.getValue());
        }
        return null;
    }

    public Field57B getField57B() {
        Tag t = this.tag("57B");
        if (t != null) {
            return new Field57B(t.getValue());
        }
        return null;
    }

    public Field57D getField57D() {
        Tag t = this.tag("57D");
        if (t != null) {
            return new Field57D(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public Field77J getField77J() {
        Tag t = this.tag("77J");
        if (t != null) {
            return new Field77J(t.getValue());
        }
        return null;
    }

    public Field77B getField77B() {
        Tag t = this.tag("77B");
        if (t != null) {
            return new Field77B(t.getValue());
        }
        return null;
    }
}

