/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt6xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57B;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field71B;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT691
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT691.class.getName());
    public static final String NAME = "691";

    public MT691(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT691(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT691 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT691(m.message());
    }

    public MT691() {
        this("TESTUS00", "TESTUS00");
    }

    public MT691(String sender, String receiver) {
        super(691, sender, receiver);
    }

    @Deprecated
    public MT691(int messageType, String sender, String receiver) {
        super(691, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT691(int, String, String)", "Use the constructor MT691(sender, receiver) instead.");
    }

    public MT691(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT691.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT691 object from FIN content with a Service Message. Check if the MT691 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT691 object from FIN content with message type " + param.getType());
        }
    }

    public static MT691 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT691(fin);
    }

    public MT691(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT691 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT691(stream);
    }

    public MT691(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT691 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT691(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT691 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT691 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT691 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field32B getField32B() {
        Tag t = this.tag("32B");
        if (t != null) {
            return new Field32B(t.getValue());
        }
        return null;
    }

    public Field52A getField52A() {
        Tag t = this.tag("52A");
        if (t != null) {
            return new Field52A(t.getValue());
        }
        return null;
    }

    public Field52D getField52D() {
        Tag t = this.tag("52D");
        if (t != null) {
            return new Field52D(t.getValue());
        }
        return null;
    }

    public Field57A getField57A() {
        Tag t = this.tag("57A");
        if (t != null) {
            return new Field57A(t.getValue());
        }
        return null;
    }

    public Field57B getField57B() {
        Tag t = this.tag("57B");
        if (t != null) {
            return new Field57B(t.getValue());
        }
        return null;
    }

    public Field57D getField57D() {
        Tag t = this.tag("57D");
        if (t != null) {
            return new Field57D(t.getValue());
        }
        return null;
    }

    public Field71B getField71B() {
        Tag t = this.tag("71B");
        if (t != null) {
            return new Field71B(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }
}

