/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt4xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32A;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field32K;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT420
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT420.class.getName());
    public static final String NAME = "420";

    public MT420(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT420(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT420 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT420(m.message());
    }

    public MT420() {
        this("TESTUS00", "TESTUS00");
    }

    public MT420(String sender, String receiver) {
        super(420, sender, receiver);
    }

    @Deprecated
    public MT420(int messageType, String sender, String receiver) {
        super(420, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT420(int, String, String)", "Use the constructor MT420(sender, receiver) instead.");
    }

    public MT420(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT420.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT420 object from FIN content with a Service Message. Check if the MT420 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT420 object from FIN content with message type " + param.getType());
        }
    }

    public static MT420 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT420(fin);
    }

    public MT420(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT420 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT420(stream);
    }

    public MT420(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT420 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT420(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT420 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT420 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT420 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field59 getField59() {
        Tag t = this.tag("59");
        if (t != null) {
            return new Field59(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field20(tags[i].getValue()));
        }
        return result;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field21(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32A> getField32A() {
        ArrayList<Field32A> result = new ArrayList<Field32A>();
        Tag[] tags = this.tags("32A");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32A(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32B(tags[i].getValue()));
        }
        return result;
    }

    public List<Field32K> getField32K() {
        ArrayList<Field32K> result = new ArrayList<Field32K>();
        Tag[] tags = this.tags("32K");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field32K(tags[i].getValue()));
        }
        return result;
    }
}

