/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field174;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT069
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT069.class.getName());
    public static final String NAME = "069";

    public MT069(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT069(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT069 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT069(m.message());
    }

    public MT069() {
        this("TESTUS00", "TESTUS00");
    }

    public MT069(String sender, String receiver) {
        super(69, sender, receiver);
    }

    @Deprecated
    public MT069(int messageType, String sender, String receiver) {
        super(69, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT069(int, String, String)", "Use the constructor MT069(sender, receiver) instead.");
    }

    public MT069(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT069.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT069 object from FIN content with a Service Message. Check if the MT069 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT069 object from FIN content with message type " + param.getType());
        }
    }

    public static MT069 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT069(fin);
    }

    public MT069(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT069 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT069(stream);
    }

    public MT069(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT069 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT069(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT069 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT069 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT069 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field174 getField174() {
        Tag t = this.tag("174");
        if (t != null) {
            return new Field174(t.getValue());
        }
        return null;
    }
}

