/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field202;
import com.prowidesoftware.swift.model.field.Field203;
import com.prowidesoftware.swift.model.field.Field305;
import com.prowidesoftware.swift.model.field.Field331;
import com.prowidesoftware.swift.model.field.Field332;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class MT051
extends AbstractMT
implements Serializable {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT051.class.getName());
    public static final String NAME = "051";

    public MT051(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT051(MtSwiftMessage m) {
        this();
        this.m = super.getSwiftMessageNotNullOrException();
        this.sanityCheck(this.m);
    }

    public static MT051 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT051(m.message());
    }

    public MT051() {
        this("TESTUS00", "TESTUS00");
    }

    public MT051(String sender, String receiver) {
        super(51, sender, receiver);
    }

    @Deprecated
    public MT051(int messageType, String sender, String receiver) {
        super(51, sender, receiver);
        DeprecationUtils.phase2(this.getClass(), "MT051(int, String, String)", "Use the constructor MT051(sender, receiver) instead.");
    }

    public MT051(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT051.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT051 object from FIN content with a Service Message. Check if the MT051 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((String)param.getType(), (String)this.getMessageType())) {
            log.warning("Creating an MT051 object from FIN content with message type " + param.getType());
        }
    }

    public static MT051 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT051(fin);
    }

    public MT051(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT051 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT051(stream);
    }

    public MT051(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT051 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT051(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT051 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT051 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT051 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public Field202 getField202() {
        Tag t = this.tag("202");
        if (t != null) {
            return new Field202(t.getValue());
        }
        return null;
    }

    public Field203 getField203() {
        Tag t = this.tag("203");
        if (t != null) {
            return new Field203(t.getValue());
        }
        return null;
    }

    public List<Field331> getField331() {
        ArrayList<Field331> result = new ArrayList<Field331>();
        Tag[] tags = this.tags("331");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field331(tags[i].getValue()));
        }
        return result;
    }

    public List<Field305> getField305() {
        ArrayList<Field305> result = new ArrayList<Field305>();
        Tag[] tags = this.tags("305");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field305(tags[i].getValue()));
        }
        return result;
    }

    public List<Field332> getField332() {
        ArrayList<Field332> result = new ArrayList<Field332>();
        Tag[] tags = this.tags("332");
        for (int i = 0; i < tags.length; ++i) {
            result.add(new Field332(tags[i].getValue()));
        }
        return result;
    }
}

