/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field68A
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "68A";
    public static final String F_68A = "68A";
    public static final String PARSER_PATTERN = "NSN/N[/N][//S]";
    public static final String COMPONENTS_PATTERN = "NCNNNS";
    public static final Integer NUMBER = 1;
    public static final Integer CURRENCY = 2;
    public static final Integer DENOMINATION = 3;
    public static final Integer MODE = 4;
    public static final Integer AMOUNT = 5;
    public static final Integer PRODUCT_CODE = 6;

    public Field68A() {
        super(6);
    }

    public Field68A(String value) {
        super(value);
    }

    public Field68A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"68A")) {
            throw new IllegalArgumentException("cannot create field 68A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(6);
        String toparse = SwiftParseUtils.getTokenFirst(value, "/");
        this.setComponent1(SwiftParseUtils.getNumericPrefix(toparse));
        String toparse2 = SwiftParseUtils.getAlphaSuffix(toparse);
        this.setComponent2(SwiftParseUtils.getAlphaPrefix(toparse2));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse2));
        this.setComponent4(SwiftParseUtils.getTokenSecond(value, "/"));
        toparse = SwiftParseUtils.getTokenThirdLast(value, "/");
        this.setComponent5(SwiftParseUtils.getTokenFirst(toparse, "//"));
        this.setComponent6(SwiftParseUtils.getTokenSecond(toparse, "//"));
    }

    public static Field68A newInstance(Field68A source) {
        Field68A cp = new Field68A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        if (this.getComponent5() != null) {
            result.append("/").append(this.getComponent5());
        }
        if (this.getComponent6() != null) {
            result.append("//").append(this.getComponent6());
        }
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("68A", value);
    }

    public static Tag emptyTag() {
        return new Tag("68A", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Number getComponent1AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public String getNumber() {
        return this.getComponent(1);
    }

    public Number getNumberAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(1));
    }

    public Field68A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field68A setComponent1(Number component1) {
        this.setComponent(1, SwiftFormatUtils.getNumber(component1));
        return this;
    }

    public Field68A setNumber(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field68A setNumber(Number component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrency() {
        return this.getComponent(2);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field68A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field68A setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field68A setCurrency(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field68A setCurrency(Currency component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getDenomination() {
        return this.getComponent(3);
    }

    public Number getDenominationAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field68A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field68A setComponent3(Number component3) {
        this.setComponent(3, SwiftFormatUtils.getNumber(component3));
        return this;
    }

    public Field68A setDenomination(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field68A setDenomination(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Number getComponent4AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public String getMode() {
        return this.getComponent(4);
    }

    public Number getModeAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(4));
    }

    public Field68A setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field68A setComponent4(Number component4) {
        this.setComponent(4, SwiftFormatUtils.getNumber(component4));
        return this;
    }

    public Field68A setMode(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field68A setMode(Number component4) {
        this.setComponent4(component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public Number getComponent5AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public String getAmount() {
        return this.getComponent(5);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(5));
    }

    public Field68A setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field68A setComponent5(Number component5) {
        this.setComponent(5, SwiftFormatUtils.getNumber(component5));
        return this;
    }

    public Field68A setAmount(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field68A setAmount(Number component5) {
        this.setComponent5(component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Deprecated
    public String getComponent6AsString() {
        return this.getComponent(6);
    }

    public String getProductCode() {
        return this.getComponent(6);
    }

    public Field68A setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field68A setProductCode(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 5) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "68A";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "6n<CUR>6n/2n[/<AMOUNT>15][//10x]";
    }

    public static Field68A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("68A");
        if (t == null) {
            return null;
        }
        return new Field68A(t);
    }

    public static Field68A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field68A.get(msg.getBlock4());
    }

    public static List<Field68A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field68A.getAll(msg.getBlock4());
    }

    public static List<Field68A> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("68A");
        if (arr != null && arr.length > 0) {
            ArrayList<Field68A> result = new ArrayList<Field68A>(arr.length);
            for (Tag f : arr) {
                result.add(new Field68A(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Number n;
        NumberFormat f;
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 68A");
        }
        if (component == 1) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent1AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 4) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent4AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 5) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            n = this.getComponent5AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Number");
        result.add("Currency");
        result.add("Denomination");
        result.add("Mode");
        result.add("Amount");
        result.add("Product Code");
        return result;
    }
}

