/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field35B
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "35B";
    public static final String F_35B = "35B";
    public static final String PARSER_PATTERN = "[<ISIN><SPACE>S][$S]0-4";
    public static final String COMPONENTS_PATTERN = "SSSSSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer ISIN = 2;
    public static final Integer DESCRIPTION = 3;
    @Deprecated
    public static final Integer IDENTIFICATION = 2;

    public Field35B() {
        super(6);
    }

    public Field35B(String value) {
        super(value);
    }

    public Field35B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"35B")) {
            throw new IllegalArgumentException("cannot create field 35B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(6);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty() && StringUtils.startsWith((String)lines.get(0), (String)"ISIN ")) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), " "));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(lines.get(0), " "));
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 1, lines);
        } else {
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 0, lines);
        }
    }

    public static Field35B newInstance(Field35B source) {
        Field35B cp = new Field35B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(this.getComponent2());
        }
        this.appendInLines(result, 3, 6);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("35B", value);
    }

    public static Tag emptyTag() {
        return new Tag("35B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field35B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field35B setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    @Deprecated
    public String getComponent2AsString() {
        return this.getComponent(2);
    }

    public String getISIN() {
        return this.getComponent(2);
    }

    public Field35B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field35B setISIN(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    @Deprecated
    public String getComponent3AsString() {
        return this.getComponent(3);
    }

    public String getDescriptionLine1() {
        return this.getComponent(3);
    }

    public String getDescriptionLine2() {
        return this.getComponent(4);
    }

    public String getDescriptionLine3() {
        return this.getComponent(5);
    }

    public String getDescriptionLine4() {
        return this.getComponent(6);
    }

    public String getDescription() {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < 7; ++i) {
            if (!StringUtils.isNotBlank((String)this.getComponent(i))) continue;
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(StringUtils.trimToEmpty((String)this.getComponent(i)));
        }
        return result.toString();
    }

    public Field35B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field35B setDescriptionLine1(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field35B setDescriptionLine2(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field35B setDescriptionLine3(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field35B setDescriptionLine4(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field35B setDescription(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 3, 4, 0, lines);
        return this;
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    @Deprecated
    public String getComponent4AsString() {
        return this.getComponent(4);
    }

    public Field35B setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    @Deprecated
    public String getComponent5AsString() {
        return this.getComponent(5);
    }

    public Field35B setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    @Deprecated
    public String getComponent6AsString() {
        return this.getComponent(6);
    }

    public Field35B setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "35B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "[<ISIN> 12!c][$][35x][$35x]0-3(****)";
    }

    public static Field35B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("35B");
        if (t == null) {
            return null;
        }
        return new Field35B(t);
    }

    public static Field35B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field35B.get(msg.getBlock4());
    }

    public static List<Field35B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field35B.getAll(msg.getBlock4());
    }

    public static List<Field35B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("35B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field35B> result = new ArrayList<Field35B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field35B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field35B cp = Field35B.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field35B cp = Field35B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field35B cp = Field35B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 35B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("ISIN");
        result.add("Description");
        result.add("Description 2");
        result.add("Description 3");
        result.add("Description 4");
        return result;
    }
}

