/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field32Q
extends Field
implements Serializable,
CurrencyContainer {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "32Q";
    public static final String F_32Q = "32Q";
    public static final String PARSER_PATTERN = "S/S";
    public static final String COMPONENTS_PATTERN = "CC";
    public static final Integer CURRENCY_1 = 1;
    public static final Integer CURRENCY_2 = 2;

    public Field32Q() {
        super(2);
    }

    public Field32Q(String value) {
        super(value);
    }

    public Field32Q(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"32Q")) {
            throw new IllegalArgumentException("cannot create field 32Q from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
    }

    public static Field32Q newInstance(Field32Q source) {
        Field32Q cp = new Field32Q();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("32Q", value);
    }

    public static Tag emptyTag() {
        return new Tag("32Q", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public String getCurrency1() {
        return this.getComponent(1);
    }

    public Currency getCurrency1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public Field32Q setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field32Q setComponent1(Currency component1) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(component1));
        return this;
    }

    public Field32Q setCurrency1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field32Q setCurrency1(Currency component1) {
        this.setComponent1(component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrency2() {
        return this.getComponent(2);
    }

    public Currency getCurrency2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field32Q setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field32Q setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field32Q setCurrency2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field32Q setCurrency2(Currency component2) {
        this.setComponent2(component2);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "32Q";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<CUR>/<CUR>";
    }

    public static Field32Q get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("32Q");
        if (t == null) {
            return null;
        }
        return new Field32Q(t);
    }

    public static Field32Q get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field32Q.get(msg.getBlock4());
    }

    public static List<Field32Q> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field32Q.getAll(msg.getBlock4());
    }

    public static List<Field32Q> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("32Q");
        if (arr != null && arr.length > 0) {
            ArrayList<Field32Q> result = new ArrayList<Field32Q>(arr.length);
            for (Tag f : arr) {
                result.add(new Field32Q(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 32Q");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Currency 1");
        result.add("Currency 2");
        return result;
    }
}

