/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field30P
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "30P";
    public static final String F_30P = "30P";
    public static final String PARSER_PATTERN = "S";
    public static final String COMPONENTS_PATTERN = "D";
    public static final Integer DATE = 1;

    public Field30P() {
        super(1);
    }

    public Field30P(String value) {
        super(value);
    }

    public Field30P(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"30P")) {
            throw new IllegalArgumentException("cannot create field 30P from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(1);
        this.setComponent1(value);
    }

    public static Field30P newInstance(Field30P source) {
        Field30P cp = new Field30P();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("30P", value);
    }

    public static Tag emptyTag() {
        return new Tag("30P", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent(1);
    }

    public Calendar getDateAsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public Field30P setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30P setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field30P setDate(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30P setDate(Calendar component1) {
        this.setComponent1(component1);
        return this;
    }

    @Override
    public List<Calendar> dates() {
        ArrayList<Calendar> result = new ArrayList<Calendar>();
        result.add(SwiftFormatUtils.getDate4(this.getComponent(1)));
        return result;
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "30P";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return "<DATE4>";
    }

    public static Field30P get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("30P");
        if (t == null) {
            return null;
        }
        return new Field30P(t);
    }

    public static Field30P get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field30P.get(msg.getBlock4());
    }

    public static List<Field30P> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field30P.getAll(msg.getBlock4());
    }

    public static List<Field30P> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("30P");
        if (arr != null && arr.length > 0) {
            ArrayList<Field30P> result = new ArrayList<Field30P>(arr.length);
            for (Tag f : arr) {
                result.add(new Field30P(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 1;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 1) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 30P");
        }
        if (component == 1) {
            DateFormat f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        return result;
    }
}

