/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class Field19B
extends Field
implements Serializable,
CurrencyContainer,
AmountContainer,
GenericField {
    public static final int SRU = 2017;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "19B";
    public static final String F_19B = "19B";
    public static final String PARSER_PATTERN = ":S//SN";
    public static final String COMPONENTS_PATTERN = "SCN";
    public static final Integer QUALIFIER = 1;
    public static final Integer CURRENCY = 2;
    public static final Integer AMOUNT = 3;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field19B() {
        super(3);
    }

    public Field19B(String value) {
        super(value);
    }

    public Field19B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((String)tag.getName(), (String)"19B")) {
            throw new IllegalArgumentException("cannot create field 19B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getAlphaPrefix(toparse));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse));
    }

    public static Field19B newInstance(Field19B source) {
        Field19B cp = new Field19B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        return result.toString();
    }

    public static Tag tag(String value) {
        return new Tag("19B", value);
    }

    public static Tag emptyTag() {
        return new Tag("19B", "");
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    @Deprecated
    public String getComponent1AsString() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent(1);
    }

    public Field19B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field19B setQualifier(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrency() {
        return this.getComponent(2);
    }

    public Currency getCurrencyAsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public Field19B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field19B setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field19B setCurrency(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field19B setCurrency(Currency component2) {
        this.setComponent2(component2);
        return this;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Number getComponent3AsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public String getAmount() {
        return this.getComponent(3);
    }

    public Number getAmountAsNumber() {
        return SwiftFormatUtils.getNumber(this.getComponent(3));
    }

    public Field19B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field19B setComponent3(Number component3) {
        this.setComponent(3, SwiftFormatUtils.getNumber(component3));
        return this;
    }

    public Field19B setAmount(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field19B setAmount(Number component3) {
        this.setComponent3(component3);
        return this;
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.resolveComponentsPattern(COMPONENTS_PATTERN, this.components);
    }

    @Override
    public List<Currency> currencies() {
        List<String> l = this.currencyStrings();
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Currency> result = new ArrayList<Currency>();
        for (String s : l) {
            result.add(Currency.getInstance(s));
        }
        return result;
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return this.getDSS() != null;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String getName() {
        return "19B";
    }

    @Override
    public final String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<CUR><AMOUNT>15";
    }

    public static Field19B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("19B");
        if (t == null) {
            return null;
        }
        return new Field19B(t);
    }

    public static Field19B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field19B.get(msg.getBlock4());
    }

    public static List<Field19B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field19B.getAll(msg.getBlock4());
    }

    public static List<Field19B> getAll(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return Collections.emptyList();
        }
        Tag[] arr = block.getTagsByName("19B");
        if (arr != null && arr.length > 0) {
            ArrayList<Field19B> result = new ArrayList<Field19B>(arr.length);
            for (Tag f : arr) {
                result.add(new Field19B(f));
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 19B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            Number n = this.getComponent3AsNumber();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Currency");
        result.add("Amount");
        return result;
    }
}

