/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.UnparsedTextList;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class SwiftBlock
implements Serializable {
    private static final long serialVersionUID = -6993261477630953757L;
    protected Long id;
    protected UnparsedTextList unparsedTexts = null;
    protected Boolean input;
    protected Boolean output;
    protected String blockType;

    public String getBlockType() {
        return this.blockType;
    }

    public void setBlockType(String blockType) {
        this.blockType = blockType;
    }

    public SwiftBlock() {
    }

    public SwiftBlock(UnparsedTextList unparsedText) {
        this.unparsedTexts = unparsedText;
    }

    protected abstract void setBlockNumber(Integer var1);

    protected abstract void setBlockName(String var1);

    public abstract Integer getNumber();

    public abstract String getName();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isTagBlock() {
        return this instanceof SwiftTagListBlock;
    }

    protected void unparsedTextVerify() {
        if (this.unparsedTexts == null) {
            this.unparsedTexts = new UnparsedTextList();
        }
    }

    public UnparsedTextList getUnparsedTexts() {
        this.unparsedTextVerify();
        return this.unparsedTexts;
    }

    public void setUnparsedTexts(UnparsedTextList texts) {
        this.unparsedTexts = texts;
    }

    public Integer getUnparsedTextsSize() {
        if (this.unparsedTexts == null) {
            return 0;
        }
        return this.unparsedTexts.size();
    }

    public Boolean unparsedTextIsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.isMessage(index);
    }

    public String unparsedTextGetText(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getText(index);
    }

    public SwiftMessage unparsedTextGetAsMessage(Integer index) {
        this.unparsedTextVerify();
        return this.unparsedTexts.getTextAsMessage(index);
    }

    public void unparsedTextAddText(String text) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(text);
    }

    public void unparsedTextAddText(SwiftMessage message) {
        this.unparsedTextVerify();
        this.unparsedTexts.addText(message);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.unparsedTexts == null ? 0 : this.unparsedTexts.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwiftBlock other = (SwiftBlock)obj;
        return !(this.unparsedTexts == null ? other.unparsedTexts != null : !this.unparsedTexts.equals(other.unparsedTexts));
    }

    public Boolean getInput() {
        return StringUtils.equals((String)this.getBlockType(), (String)"2I");
    }

    public void setInput(Boolean input) {
        this.input = input;
    }

    public Boolean getOutput() {
        return StringUtils.equals((String)this.getBlockType(), (String)"2O");
    }

    public void setOutput(Boolean output) {
        this.output = output;
    }
}

