/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.io.parser.MxParser;
import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.MxBusinessProcess;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.MxNode;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.BusinessHeader;
import com.prowidesoftware.swift.model.mx.dic.ApplicationHeader;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class MxSwiftMessage
extends AbstractSwiftMessage {
    private static final long serialVersionUID = -4394356007627575831L;
    private static final transient Logger log = Logger.getLogger(MxSwiftMessage.class.getName());
    private MxBusinessProcess businessProcess;
    private String functionality;
    private String variant;
    private String version;

    public MxSwiftMessage() {
    }

    public MxSwiftMessage(String xml) {
        super(xml);
    }

    public static MxSwiftMessage parse(String xml) {
        return new MxSwiftMessage(xml);
    }

    public MxSwiftMessage(InputStream stream) throws IOException {
        super(stream);
    }

    public static MxSwiftMessage parse(InputStream stream) throws IOException {
        return new MxSwiftMessage(stream);
    }

    public MxSwiftMessage(File file) throws IOException {
        super(file);
    }

    public static MxSwiftMessage parse(File file) throws IOException {
        return new MxSwiftMessage(file);
    }

    public MxSwiftMessage(AbstractMX mx) {
        super(mx.message("message"));
    }

    @Override
    protected void updateFromMessage() {
        this._updateFromMessage(null);
    }

    private void _updateFromMessage(MxId id) {
        if (this.message() != null && this.message().length() > 0) {
            MxParser parser = new MxParser(this.message());
            BusinessHeader h = parser.parseBusinessHeader();
            if (!this._update(h)) {
                this._update(parser.parse());
            }
            if (id != null) {
                this._update(id);
            } else {
                this._update(parser.detectMessage());
            }
        }
    }

    public void updateFromXML(String xml) {
        this.updateFromXML(xml, null);
    }

    public void updateFromXML(String xml, MxId id) {
        Validate.notNull((Object)xml, (String)"the xml message parameter cannot be null");
        this.setMessage(xml);
        this.setFileFormat(FileFormat.MX);
        this._updateFromMessage(id);
    }

    public void updateFromModel(AbstractMX mx) {
        Validate.notNull((Object)mx, (String)"the mx parameter cannot be null");
        this.setMessage(mx.message("message", true));
        this.setFileFormat(FileFormat.MX);
        if (!this._update(mx.getBusinessHeader())) {
            MxParser parser = new MxParser(this.message());
            this._update(parser.parse());
        }
        this._update(mx.getMxId());
    }

    private boolean _update(MxId id) {
        if (id != null) {
            this.identifier = id.id();
            this.businessProcess = id.getBusinessProcess();
            this.functionality = id.getFunctionality();
            this.variant = id.getVariant();
            this.version = id.getVersion();
            return true;
        }
        return false;
    }

    private boolean _update(BusinessHeader h) {
        boolean updated = false;
        if (h != null) {
            String reference;
            String to;
            String from = h.from();
            if (from != null) {
                this.sender = StringUtils.substring((String)from, (int)0, (int)8);
                updated = true;
            }
            if ((to = h.to()) != null) {
                this.receiver = StringUtils.substring((String)to, (int)0, (int)8);
                updated = true;
            }
            if ((reference = h.reference()) != null) {
                this.setReference(h.reference());
                updated = true;
            }
        }
        return updated;
    }

    private boolean _update(MxNode n) {
        boolean updated = false;
        MxNode groupHeader = n.findFirstByName("GrpHdr");
        if (groupHeader != null) {
            MxNode reference;
            MxNode receiverBic;
            MxNode senderBic = groupHeader.findFirst("./InstgAgt/FinInstnId/BIC");
            if (senderBic != null) {
                this.sender = StringUtils.substring((String)senderBic.getValue(), (int)0, (int)8);
                updated = true;
            }
            if ((receiverBic = groupHeader.findFirst("./InstdAgt/FinInstnId/BIC")) != null) {
                this.receiver = StringUtils.substring((String)receiverBic.getValue(), (int)0, (int)8);
                updated = true;
            }
            if ((reference = groupHeader.findFirst("./MsgId")) != null) {
                this.setReference(reference.getValue());
                updated = true;
            }
        }
        return updated;
    }

    public MxBusinessProcess getBusinessProcess() {
        return this.businessProcess;
    }

    public void setBusinessProcess(MxBusinessProcess businessProcess) {
        this.businessProcess = businessProcess;
    }

    public String getFunctionality() {
        return this.functionality;
    }

    public void setFunctionality(String functionality) {
        this.functionality = functionality;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.businessProcess == null ? 0 : this.businessProcess.hashCode());
        result = 31 * result + (this.functionality == null ? 0 : this.functionality.hashCode());
        result = 31 * result + (this.variant == null ? 0 : this.variant.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MxSwiftMessage other = (MxSwiftMessage)obj;
        if (this.businessProcess != other.businessProcess) {
            return false;
        }
        if (this.functionality == null ? other.functionality != null : !this.functionality.equals(other.functionality)) {
            return false;
        }
        if (this.variant == null ? other.variant != null : !this.variant.equals(other.variant)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    @Override
    @Deprecated
    public MxSwiftMessage readFile(File file) throws IOException {
        DeprecationUtils.phase3(this.getClass(), "readFile(File)", "Use the constructor MxSwiftMessage(File) instead.");
        MxSwiftMessage result = new MxSwiftMessage();
        result.setMessage(Lib.readFile(file));
        result.setFilename(file.getAbsolutePath());
        return result;
    }

    @Deprecated
    protected void setDataFromNamespace(String namespace) {
        MxBusinessProcess bpEnum;
        DeprecationUtils.phase3(this.getClass(), "setDataFromNamespace(String)", "The internal metadata is set automatically from the message content when the object is constructed from String, File or Stream.");
        Validate.notNull((Object)namespace, (String)"namespace can not be null");
        String[] tokens = StringUtils.split((String)namespace, (char)'.');
        if (tokens == null || tokens.length < 4) {
            throw new IllegalArgumentException("Expected at least 4 tokens in namespace '" + namespace + "'");
        }
        String bp = tokens[tokens.length - 4];
        String func = tokens[tokens.length - 3];
        String var = tokens[tokens.length - 2];
        String ver = tokens[tokens.length - 1];
        try {
            bpEnum = MxBusinessProcess.valueOf(bp);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown business process '" + bp + "'", e);
        }
        this.setBusinessProcess(bpEnum);
        this.setFunctionality(func);
        this.setVariant(var);
        this.setVersion(ver);
    }

    public BusinessHeader getBusinessHeader() {
        MxParser parser = new MxParser(this.message());
        return parser.parseBusinessHeader();
    }

    @Deprecated
    public ApplicationHeader getApplicationHeader() {
        MxParser parser = new MxParser(this.message());
        BusinessHeader h = parser.parseBusinessHeader();
        if (h != null && h.getApplicationHeader() != null) {
            return h.getApplicationHeader();
        }
        return null;
    }

    @Deprecated
    public void setApplicationHeader(ApplicationHeader applicationHeader) {
        log.warning("Obsolete API call. The application header is no longer stored as class attribute in " + this.getClass().getName());
    }

    public void copyTo(MxSwiftMessage msg) {
        super.copyTo(msg);
        msg.setFunctionality(this.getFunctionality());
        msg.setVariant(this.getVariant());
        msg.setVersion(this.getVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MxSwiftMessage id=").append(this.getId()).append(" message=").append(this.getMessage());
        return sb.toString();
    }
}

