/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.utils;

import com.prove.proveapi.utils.QueryParameter;
import com.prove.proveapi.utils.SerializedBody;
import com.prove.proveapi.utils.Utf8UrlEncoder;
import com.prove.proveapi.utils.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HTTPRequest {
    private static final String FRAGMENT_SEGMENT_START = "#";
    private static final String QUERY_NAME_VALUE_DELIMITER = "=";
    private static final String QUERY_PARAMETER_DELIMITER = "&";
    private static final String QUERY_SEGMENT_START = "?";
    private final String baseURL;
    private final String method;
    private final List<QueryParameter> queryParams = new ArrayList<QueryParameter>();
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Optional<SerializedBody> body = Optional.empty();

    public HTTPRequest(String baseURL, String method) {
        Utils.checkNotNull(baseURL, "baseURL");
        Utils.checkNotNull(method, "method");
        this.baseURL = baseURL;
        this.method = method;
    }

    public void setBody(Optional<SerializedBody> body) {
        Utils.checkNotNull(body, "body");
        this.body = body;
    }

    public HTTPRequest addHeader(String key, String value) {
        List<String> headerValues = this.headers.get(key);
        if (headerValues == null) {
            headerValues = new ArrayList<String>();
            this.headers.put(key, headerValues);
        }
        headerValues.add(value);
        return this;
    }

    public HTTPRequest addHeaders(Map<String, List<String>> map) {
        map.forEach((key, list) -> list.forEach(v -> this.addHeader((String)key, (String)v)));
        return this;
    }

    public HTTPRequest addQueryParam(QueryParameter param) {
        this.queryParams.add(param);
        return this;
    }

    public HTTPRequest addQueryParam(String key, String value, boolean allowReserved) {
        this.queryParams.add(QueryParameter.of(key, value, allowReserved));
        return this;
    }

    public HTTPRequest addQueryParams(Collection<QueryParameter> params) {
        params.forEach(p -> this.addQueryParam((QueryParameter)p));
        return this;
    }

    public HttpRequest build() {
        HttpRequest.BodyPublisher bodyPublisher;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
        if (this.body.isPresent()) {
            bodyPublisher = this.body.get().body();
            requestBuilder.header("Content-Type", this.body.get().contentType());
        } else {
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        }
        requestBuilder.method(this.method, bodyPublisher);
        try {
            requestBuilder.uri(new URI(HTTPRequest.buildUrl(this.baseURL, this.queryParams)));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.headers.forEach((k, list) -> list.forEach(v -> requestBuilder.header((String)k, (String)v)));
        return requestBuilder.build();
    }

    public static String buildUrl(String baseURL, Collection<QueryParameter> queryParams) {
        String fragment;
        String base;
        if (queryParams.isEmpty()) {
            return baseURL;
        }
        int i = baseURL.indexOf(FRAGMENT_SEGMENT_START);
        if (i == -1) {
            base = baseURL;
            fragment = "";
        } else {
            base = baseURL.substring(0, i);
            fragment = baseURL.substring(i);
        }
        StringBuilder b = new StringBuilder(base);
        if (!base.contains(QUERY_SEGMENT_START)) {
            b.append(QUERY_SEGMENT_START);
        } else {
            b.append(QUERY_PARAMETER_DELIMITER);
        }
        boolean first = true;
        for (QueryParameter p : queryParams) {
            if (!first) {
                b.append(QUERY_PARAMETER_DELIMITER);
            }
            first = false;
            b.append(Utf8UrlEncoder.DEFAULT.encode(p.name()));
            b.append(QUERY_NAME_VALUE_DELIMITER);
            b.append(Utf8UrlEncoder.allowReserved(p.allowReserved()).encode(p.value()));
        }
        b.append(fragment);
        return b.toString();
    }
}

