/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.prove.proveapi.models.components.V3VerifyStatusResponse;
import com.prove.proveapi.utils.Response;
import com.prove.proveapi.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class V3VerifyStatusRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends V3VerifyStatusResponse> v3VerifyStatusResponse;
    private Map<String, List<String>> headers;

    @JsonCreator
    public V3VerifyStatusRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends V3VerifyStatusResponse> v3VerifyStatusResponse, Map<String, List<String>> headers) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(v3VerifyStatusResponse, "v3VerifyStatusResponse");
        headers = Utils.emptyMapIfNull(headers);
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.v3VerifyStatusResponse = v3VerifyStatusResponse;
        this.headers = headers;
    }

    public V3VerifyStatusRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Map<String, List<String>> headers) {
        this(contentType, statusCode, rawResponse, Optional.empty(), headers);
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<V3VerifyStatusResponse> v3VerifyStatusResponse() {
        return this.v3VerifyStatusResponse;
    }

    @JsonIgnore
    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3VerifyStatusRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public V3VerifyStatusRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public V3VerifyStatusRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public V3VerifyStatusRequestResponse withV3VerifyStatusResponse(V3VerifyStatusResponse v3VerifyStatusResponse) {
        Utils.checkNotNull(v3VerifyStatusResponse, "v3VerifyStatusResponse");
        this.v3VerifyStatusResponse = Optional.ofNullable(v3VerifyStatusResponse);
        return this;
    }

    public V3VerifyStatusRequestResponse withV3VerifyStatusResponse(Optional<? extends V3VerifyStatusResponse> v3VerifyStatusResponse) {
        Utils.checkNotNull(v3VerifyStatusResponse, "v3VerifyStatusResponse");
        this.v3VerifyStatusResponse = v3VerifyStatusResponse;
        return this;
    }

    public V3VerifyStatusRequestResponse withHeaders(Map<String, List<String>> headers) {
        Utils.checkNotNull(headers, "headers");
        this.headers = headers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3VerifyStatusRequestResponse other = (V3VerifyStatusRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.v3VerifyStatusResponse, other.v3VerifyStatusResponse) && Objects.deepEquals(this.headers, other.headers);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.v3VerifyStatusResponse, this.headers);
    }

    public String toString() {
        return Utils.toString(V3VerifyStatusRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "v3VerifyStatusResponse", this.v3VerifyStatusResponse, "headers", this.headers);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends V3VerifyStatusResponse> v3VerifyStatusResponse = Optional.empty();
        private Map<String, List<String>> headers;

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder v3VerifyStatusResponse(V3VerifyStatusResponse v3VerifyStatusResponse) {
            Utils.checkNotNull(v3VerifyStatusResponse, "v3VerifyStatusResponse");
            this.v3VerifyStatusResponse = Optional.ofNullable(v3VerifyStatusResponse);
            return this;
        }

        public Builder v3VerifyStatusResponse(Optional<? extends V3VerifyStatusResponse> v3VerifyStatusResponse) {
            Utils.checkNotNull(v3VerifyStatusResponse, "v3VerifyStatusResponse");
            this.v3VerifyStatusResponse = v3VerifyStatusResponse;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            Utils.checkNotNull(headers, "headers");
            this.headers = headers;
            return this;
        }

        public V3VerifyStatusRequestResponse build() {
            return new V3VerifyStatusRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.v3VerifyStatusResponse, this.headers);
        }
    }
}

