/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.prove.proveapi.models.components.V3TokenResponse;
import com.prove.proveapi.utils.Response;
import com.prove.proveapi.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class V3TokenRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends V3TokenResponse> v3TokenResponse;

    @JsonCreator
    public V3TokenRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends V3TokenResponse> v3TokenResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(v3TokenResponse, "v3TokenResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.v3TokenResponse = v3TokenResponse;
    }

    public V3TokenRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<V3TokenResponse> v3TokenResponse() {
        return this.v3TokenResponse;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3TokenRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public V3TokenRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public V3TokenRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public V3TokenRequestResponse withV3TokenResponse(V3TokenResponse v3TokenResponse) {
        Utils.checkNotNull(v3TokenResponse, "v3TokenResponse");
        this.v3TokenResponse = Optional.ofNullable(v3TokenResponse);
        return this;
    }

    public V3TokenRequestResponse withV3TokenResponse(Optional<? extends V3TokenResponse> v3TokenResponse) {
        Utils.checkNotNull(v3TokenResponse, "v3TokenResponse");
        this.v3TokenResponse = v3TokenResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3TokenRequestResponse other = (V3TokenRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.v3TokenResponse, other.v3TokenResponse);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.v3TokenResponse);
    }

    public String toString() {
        return Utils.toString(V3TokenRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "v3TokenResponse", this.v3TokenResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends V3TokenResponse> v3TokenResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder v3TokenResponse(V3TokenResponse v3TokenResponse) {
            Utils.checkNotNull(v3TokenResponse, "v3TokenResponse");
            this.v3TokenResponse = Optional.ofNullable(v3TokenResponse);
            return this;
        }

        public Builder v3TokenResponse(Optional<? extends V3TokenResponse> v3TokenResponse) {
            Utils.checkNotNull(v3TokenResponse, "v3TokenResponse");
            this.v3TokenResponse = v3TokenResponse;
            return this;
        }

        public V3TokenRequestResponse build() {
            return new V3TokenRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.v3TokenResponse);
        }
    }
}

