/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.prove.proveapi.models.components.V3StartResponse;
import com.prove.proveapi.utils.Response;
import com.prove.proveapi.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class V3StartRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends V3StartResponse> v3StartResponse;

    @JsonCreator
    public V3StartRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends V3StartResponse> v3StartResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(v3StartResponse, "v3StartResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.v3StartResponse = v3StartResponse;
    }

    public V3StartRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<V3StartResponse> v3StartResponse() {
        return this.v3StartResponse;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3StartRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public V3StartRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public V3StartRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public V3StartRequestResponse withV3StartResponse(V3StartResponse v3StartResponse) {
        Utils.checkNotNull(v3StartResponse, "v3StartResponse");
        this.v3StartResponse = Optional.ofNullable(v3StartResponse);
        return this;
    }

    public V3StartRequestResponse withV3StartResponse(Optional<? extends V3StartResponse> v3StartResponse) {
        Utils.checkNotNull(v3StartResponse, "v3StartResponse");
        this.v3StartResponse = v3StartResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3StartRequestResponse other = (V3StartRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.v3StartResponse, other.v3StartResponse);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.v3StartResponse);
    }

    public String toString() {
        return Utils.toString(V3StartRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "v3StartResponse", this.v3StartResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends V3StartResponse> v3StartResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder v3StartResponse(V3StartResponse v3StartResponse) {
            Utils.checkNotNull(v3StartResponse, "v3StartResponse");
            this.v3StartResponse = Optional.ofNullable(v3StartResponse);
            return this;
        }

        public Builder v3StartResponse(Optional<? extends V3StartResponse> v3StartResponse) {
            Utils.checkNotNull(v3StartResponse, "v3StartResponse");
            this.v3StartResponse = v3StartResponse;
            return this;
        }

        public V3StartRequestResponse build() {
            return new V3StartRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.v3StartResponse);
        }
    }
}

