/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class DataSourceNameResponseInternal {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="firstName")
    private Optional<Long> firstName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="lastName")
    private Optional<Long> lastName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="nameScore")
    private Optional<Long> nameScore;

    @JsonCreator
    public DataSourceNameResponseInternal(@JsonProperty(value="firstName") Optional<Long> firstName, @JsonProperty(value="lastName") Optional<Long> lastName, @JsonProperty(value="nameScore") Optional<Long> nameScore) {
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(nameScore, "nameScore");
        this.firstName = firstName;
        this.lastName = lastName;
        this.nameScore = nameScore;
    }

    public DataSourceNameResponseInternal() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Long> firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public Optional<Long> lastName() {
        return this.lastName;
    }

    @JsonIgnore
    public Optional<Long> nameScore() {
        return this.nameScore;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public DataSourceNameResponseInternal withFirstName(long firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = Optional.ofNullable(firstName);
        return this;
    }

    public DataSourceNameResponseInternal withFirstName(Optional<Long> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public DataSourceNameResponseInternal withLastName(long lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = Optional.ofNullable(lastName);
        return this;
    }

    public DataSourceNameResponseInternal withLastName(Optional<Long> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public DataSourceNameResponseInternal withNameScore(long nameScore) {
        Utils.checkNotNull(nameScore, "nameScore");
        this.nameScore = Optional.ofNullable(nameScore);
        return this;
    }

    public DataSourceNameResponseInternal withNameScore(Optional<Long> nameScore) {
        Utils.checkNotNull(nameScore, "nameScore");
        this.nameScore = nameScore;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceNameResponseInternal other = (DataSourceNameResponseInternal)o;
        return Objects.deepEquals(this.firstName, other.firstName) && Objects.deepEquals(this.lastName, other.lastName) && Objects.deepEquals(this.nameScore, other.nameScore);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.nameScore);
    }

    public String toString() {
        return Utils.toString(DataSourceNameResponseInternal.class, "firstName", this.firstName, "lastName", this.lastName, "nameScore", this.nameScore);
    }

    public static final class Builder {
        private Optional<Long> firstName = Optional.empty();
        private Optional<Long> lastName = Optional.empty();
        private Optional<Long> nameScore = Optional.empty();

        private Builder() {
        }

        public Builder firstName(long firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Optional<Long> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(long lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Optional<Long> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        public Builder nameScore(long nameScore) {
            Utils.checkNotNull(nameScore, "nameScore");
            this.nameScore = Optional.ofNullable(nameScore);
            return this;
        }

        public Builder nameScore(Optional<Long> nameScore) {
            Utils.checkNotNull(nameScore, "nameScore");
            this.nameScore = nameScore;
            return this;
        }

        public DataSourceNameResponseInternal build() {
            return new DataSourceNameResponseInternal(this.firstName, this.lastName, this.nameScore);
        }
    }
}

