/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.models.components.DataSourceAddressResponseInternal;
import com.prove.proveapi.models.components.DataSourceEmailAddressResponseInternal;
import com.prove.proveapi.models.components.DataSourceIdentifiersResponseInternal;
import com.prove.proveapi.models.components.DataSourceNameResponseInternal;
import com.prove.proveapi.utils.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DataSourceInternal {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="address")
    private Optional<? extends DataSourceAddressResponseInternal> address;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="cipConfidence")
    private Optional<String> cipConfidence;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="email")
    private Optional<? extends DataSourceEmailAddressResponseInternal> email;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="identifiers")
    private Optional<? extends DataSourceIdentifiersResponseInternal> identifiers;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="name")
    private Optional<? extends DataSourceNameResponseInternal> name;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="reasonCodes")
    private Optional<? extends List<String>> reasonCodes;

    @JsonCreator
    public DataSourceInternal(@JsonProperty(value="address") Optional<? extends DataSourceAddressResponseInternal> address, @JsonProperty(value="cipConfidence") Optional<String> cipConfidence, @JsonProperty(value="email") Optional<? extends DataSourceEmailAddressResponseInternal> email, @JsonProperty(value="identifiers") Optional<? extends DataSourceIdentifiersResponseInternal> identifiers, @JsonProperty(value="name") Optional<? extends DataSourceNameResponseInternal> name, @JsonProperty(value="reasonCodes") Optional<? extends List<String>> reasonCodes) {
        Utils.checkNotNull(address, "address");
        Utils.checkNotNull(cipConfidence, "cipConfidence");
        Utils.checkNotNull(email, "email");
        Utils.checkNotNull(identifiers, "identifiers");
        Utils.checkNotNull(name, "name");
        Utils.checkNotNull(reasonCodes, "reasonCodes");
        this.address = address;
        this.cipConfidence = cipConfidence;
        this.email = email;
        this.identifiers = identifiers;
        this.name = name;
        this.reasonCodes = reasonCodes;
    }

    public DataSourceInternal() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<DataSourceAddressResponseInternal> address() {
        return this.address;
    }

    @JsonIgnore
    public Optional<String> cipConfidence() {
        return this.cipConfidence;
    }

    @JsonIgnore
    public Optional<DataSourceEmailAddressResponseInternal> email() {
        return this.email;
    }

    @JsonIgnore
    public Optional<DataSourceIdentifiersResponseInternal> identifiers() {
        return this.identifiers;
    }

    @JsonIgnore
    public Optional<DataSourceNameResponseInternal> name() {
        return this.name;
    }

    @JsonIgnore
    public Optional<List<String>> reasonCodes() {
        return this.reasonCodes;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public DataSourceInternal withAddress(DataSourceAddressResponseInternal address) {
        Utils.checkNotNull(address, "address");
        this.address = Optional.ofNullable(address);
        return this;
    }

    public DataSourceInternal withAddress(Optional<? extends DataSourceAddressResponseInternal> address) {
        Utils.checkNotNull(address, "address");
        this.address = address;
        return this;
    }

    public DataSourceInternal withCipConfidence(String cipConfidence) {
        Utils.checkNotNull(cipConfidence, "cipConfidence");
        this.cipConfidence = Optional.ofNullable(cipConfidence);
        return this;
    }

    public DataSourceInternal withCipConfidence(Optional<String> cipConfidence) {
        Utils.checkNotNull(cipConfidence, "cipConfidence");
        this.cipConfidence = cipConfidence;
        return this;
    }

    public DataSourceInternal withEmail(DataSourceEmailAddressResponseInternal email) {
        Utils.checkNotNull(email, "email");
        this.email = Optional.ofNullable(email);
        return this;
    }

    public DataSourceInternal withEmail(Optional<? extends DataSourceEmailAddressResponseInternal> email) {
        Utils.checkNotNull(email, "email");
        this.email = email;
        return this;
    }

    public DataSourceInternal withIdentifiers(DataSourceIdentifiersResponseInternal identifiers) {
        Utils.checkNotNull(identifiers, "identifiers");
        this.identifiers = Optional.ofNullable(identifiers);
        return this;
    }

    public DataSourceInternal withIdentifiers(Optional<? extends DataSourceIdentifiersResponseInternal> identifiers) {
        Utils.checkNotNull(identifiers, "identifiers");
        this.identifiers = identifiers;
        return this;
    }

    public DataSourceInternal withName(DataSourceNameResponseInternal name) {
        Utils.checkNotNull(name, "name");
        this.name = Optional.ofNullable(name);
        return this;
    }

    public DataSourceInternal withName(Optional<? extends DataSourceNameResponseInternal> name) {
        Utils.checkNotNull(name, "name");
        this.name = name;
        return this;
    }

    public DataSourceInternal withReasonCodes(List<String> reasonCodes) {
        Utils.checkNotNull(reasonCodes, "reasonCodes");
        this.reasonCodes = Optional.ofNullable(reasonCodes);
        return this;
    }

    public DataSourceInternal withReasonCodes(Optional<? extends List<String>> reasonCodes) {
        Utils.checkNotNull(reasonCodes, "reasonCodes");
        this.reasonCodes = reasonCodes;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceInternal other = (DataSourceInternal)o;
        return Objects.deepEquals(this.address, other.address) && Objects.deepEquals(this.cipConfidence, other.cipConfidence) && Objects.deepEquals(this.email, other.email) && Objects.deepEquals(this.identifiers, other.identifiers) && Objects.deepEquals(this.name, other.name) && Objects.deepEquals(this.reasonCodes, other.reasonCodes);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.cipConfidence, this.email, this.identifiers, this.name, this.reasonCodes);
    }

    public String toString() {
        return Utils.toString(DataSourceInternal.class, "address", this.address, "cipConfidence", this.cipConfidence, "email", this.email, "identifiers", this.identifiers, "name", this.name, "reasonCodes", this.reasonCodes);
    }

    public static final class Builder {
        private Optional<? extends DataSourceAddressResponseInternal> address = Optional.empty();
        private Optional<String> cipConfidence = Optional.empty();
        private Optional<? extends DataSourceEmailAddressResponseInternal> email = Optional.empty();
        private Optional<? extends DataSourceIdentifiersResponseInternal> identifiers = Optional.empty();
        private Optional<? extends DataSourceNameResponseInternal> name = Optional.empty();
        private Optional<? extends List<String>> reasonCodes = Optional.empty();

        private Builder() {
        }

        public Builder address(DataSourceAddressResponseInternal address) {
            Utils.checkNotNull(address, "address");
            this.address = Optional.ofNullable(address);
            return this;
        }

        public Builder address(Optional<? extends DataSourceAddressResponseInternal> address) {
            Utils.checkNotNull(address, "address");
            this.address = address;
            return this;
        }

        public Builder cipConfidence(String cipConfidence) {
            Utils.checkNotNull(cipConfidence, "cipConfidence");
            this.cipConfidence = Optional.ofNullable(cipConfidence);
            return this;
        }

        public Builder cipConfidence(Optional<String> cipConfidence) {
            Utils.checkNotNull(cipConfidence, "cipConfidence");
            this.cipConfidence = cipConfidence;
            return this;
        }

        public Builder email(DataSourceEmailAddressResponseInternal email) {
            Utils.checkNotNull(email, "email");
            this.email = Optional.ofNullable(email);
            return this;
        }

        public Builder email(Optional<? extends DataSourceEmailAddressResponseInternal> email) {
            Utils.checkNotNull(email, "email");
            this.email = email;
            return this;
        }

        public Builder identifiers(DataSourceIdentifiersResponseInternal identifiers) {
            Utils.checkNotNull(identifiers, "identifiers");
            this.identifiers = Optional.ofNullable(identifiers);
            return this;
        }

        public Builder identifiers(Optional<? extends DataSourceIdentifiersResponseInternal> identifiers) {
            Utils.checkNotNull(identifiers, "identifiers");
            this.identifiers = identifiers;
            return this;
        }

        public Builder name(DataSourceNameResponseInternal name) {
            Utils.checkNotNull(name, "name");
            this.name = Optional.ofNullable(name);
            return this;
        }

        public Builder name(Optional<? extends DataSourceNameResponseInternal> name) {
            Utils.checkNotNull(name, "name");
            this.name = name;
            return this;
        }

        public Builder reasonCodes(List<String> reasonCodes) {
            Utils.checkNotNull(reasonCodes, "reasonCodes");
            this.reasonCodes = Optional.ofNullable(reasonCodes);
            return this;
        }

        public Builder reasonCodes(Optional<? extends List<String>> reasonCodes) {
            Utils.checkNotNull(reasonCodes, "reasonCodes");
            this.reasonCodes = reasonCodes;
            return this;
        }

        public DataSourceInternal build() {
            return new DataSourceInternal(this.address, this.cipConfidence, this.email, this.identifiers, this.name, this.reasonCodes);
        }
    }
}

