/*
 * Decompiled with CFR 0.152.
 */
package com.proton.ecgcard.algorithm.interfaces;

import android.os.Handler;
import android.os.Looper;
import com.proton.ecgcard.algorithm.bean.AlgorithmResult;
import com.proton.ecgcard.algorithm.bean.InsparaData;
import com.proton.ecgcard.algorithm.bean.RealECGData;
import com.proton.ecgcard.algorithm.callback.AlgorithmResultListener;
import com.proton.ecgcard.algorithm.interfaces.IFilterAlgorithm;
import com.proton.ecgcard.algorithm.utils.FilterAlgorithmHelper;
import java.util.ArrayList;
import java.util.List;

public class CardFilterAlgorithm
implements IFilterAlgorithm {
    private Handler mainHandler = new Handler(Looper.getMainLooper());

    @Override
    public RealECGData processEcgData(List<Float> list, long l, int n, int n2, int n3, int n4, int n5, int n6) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = list.get(i).floatValue();
        }
        return FilterAlgorithmHelper.processEcgData(dArray, l, n, n2, n3, n4, n5, n6);
    }

    @Override
    public void fullanalyse(final List<Float> list, final int n, final int n2, final int n3, final int n4, final int n5, final int n6, final AlgorithmResultListener algorithmResultListener) {
        new Thread(new Runnable(){

            @Override
            public final void run() {
                final AlgorithmResult algorithmResult = CardFilterAlgorithm.this.fullanalyse(list, n, n2, n3, n4, n5, n6);
                CardFilterAlgorithm.this.mainHandler.post(new Runnable(){

                    @Override
                    public final void run() {
                        if (algorithmResult != null && algorithmResultListener != null) {
                            algorithmResultListener.receiveAlgorithmResult(algorithmResult);
                        }
                    }
                });
            }
        }).start();
    }

    @Override
    public AlgorithmResult fullanalyse(List<Float> list, int n, int n2, int n3, int n4, int n5, int n6) {
        list = new ArrayList<Float>(list);
        double[] dArray = new double[list.size()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = list.get(i).floatValue();
        }
        AlgorithmResult algorithmResult = FilterAlgorithmHelper.fullanalyse(dArray, n, n2, n3, n4, n5, n6);
        list.clear();
        return algorithmResult;
    }

    @Override
    public InsparaData insparaHrvData(List<Float> list, int n, int n2, long l, int n3, int n4) {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = list.get(i).floatValue();
        }
        return FilterAlgorithmHelper.insparaHrvData(dArray, n, n2, l, n3, n4);
    }

    @Override
    public int dataModified(int[] nArray, boolean[] blArray) {
        return FilterAlgorithmHelper.dataModified(nArray, blArray);
    }
}

