package com.proton.ecgcard.algorithm.utils;

import com.proton.ecgcard.algorithm.BuildConfig;
import com.proton.ecgcard.algorithm.bean.AlgorithmResult;
import com.proton.ecgcard.algorithm.bean.InsparaData;
import com.proton.ecgcard.algorithm.bean.RealECGData;

/**
 * Created by 王梦思 on 2017/7/21.
 * 算法处理
 */

public class FilterAlgorithmHelper {
    static {
        System.loadLibrary("ecgpatch");
        System.loadLibrary("ecgcardalgorithm");
        init(BuildConfig.DEBUG);
    }

    public static native void init(boolean isDebug);

    /**
     * 滤波处理算法（用户版本）
     */
    public static native RealECGData processEcgData(double[] doubles, long section, int sample, int band50Switch, int band100Switch, int lowpassSwitch, int highpassSwitch, int smoothSwitch);

    /**
     * 滤波处理算法完整分析(用户板)
     */
    public static native AlgorithmResult fullanalyse(double[] ecgDatas, int sample, int band50Switch, int band100Switch, int lowpassSwitch, int highpassSwitch, int smoothSwitch);

    /**
     * 滤波处理算法完整分析(用户板)
     */
    public static native InsparaData insparaHrvData(double[] datas, int heartRate, int signalQualityIndex, long section, int sampr, int age);

    /**
     * 基于用户状态的心电数据修改
     * userStatus：用户状态数组
     * userStatus[0]——表征用户当前状态：0 未选择；1 晨起；2 睡前；3 午休后；4 运动后。
     * userStatus[1]——表征用户是否服药：0 未服药；1 服药。
     * userStatus[2]——表征用户是否饮酒：0 未饮酒；1 饮酒。
     * userStatus[3]——表征用户是否喝浓茶：0 未喝茶；1 喝浓茶。
     * userStatus[4]——表征用户是否喝咖啡：0 未喝咖啡；1 喝咖啡。
     * drugStatus：每种药品的服用状态, false 未服用 true 服用
     * drugStatus[0]——胺碘酮
     * drugStatus[1]——美西律
     * drugStatus[2]——地高辛
     * drugStatus[3]——普罗帕酮
     * drugStatus[4]——美托洛尔
     * drugStatus[5]——其他药物
     *
     * @return 表征心律失常的判断条件：0 由早搏房颤、心动过速、心动过缓共同判断；1 由早搏房颤和心动过缓判断；2 由早搏房颤和心动过速判断。
     */
    public static native int dataModified(int userStatus[], boolean drugStatus[]);

}
