/*
 * Decompiled with CFR 0.152.
 */
package com.projectplace.android.syncmanager;

import androidx.annotation.NonNull;
import com.projectplace.android.syncmanager.SyncFetch;
import com.projectplace.android.syncmanager.SyncManager;
import com.projectplace.android.syncmanager.SyncObject;
import java.util.ArrayList;
import java.util.List;

public abstract class SyncFetchGroup
extends SyncFetch {
    private List<SyncFetch> mFetches = new ArrayList<SyncFetch>();
    private SyncManager mSyncManager;

    protected abstract void onAddFetches();

    public SyncFetchGroup(SyncManager syncManager) {
        this.mSyncManager = syncManager;
    }

    @Override
    public final void onSave() {
        for (SyncFetch fetch : this.mFetches) {
            fetch.onSave();
        }
        this.onSaveGroup();
    }

    protected void onSaveGroup() {
    }

    @Override
    public final void onReset() {
        this.mFetches.clear();
        this.onResetGroup();
    }

    protected void onResetGroup() {
    }

    @Override
    public final void onStart() {
        this.onAddFetches();
        if (this.mFetches.size() == 0) {
            throw new RuntimeException("Can not start fetch group with no fetches added");
        }
    }

    @Override
    public final boolean isDone() {
        if (this.mFetches.size() == 0) {
            return false;
        }
        for (SyncFetch fetch : this.mFetches) {
            if (fetch.isDone()) continue;
            return false;
        }
        return true;
    }

    protected void add(SyncFetch fetch) {
        fetch.setIsGroupFetch(true);
        fetch.setSyncListener(new SyncObject.SyncListenerAdapter(){

            @Override
            public void onFetchDone(@NonNull SyncFetch syncFetch) {
                if (syncFetch.isFailed()) {
                    SyncFetchGroup.this.setErrorAndMessage(syncFetch.getError(), syncFetch.getErrorMessage());
                }
                SyncFetchGroup.this.checkIfDone();
            }
        });
        this.mFetches.add(fetch);
        this.mSyncManager.fetch(fetch);
    }
}

