/*
 * Decompiled with CFR 0.152.
 */
package com.projectplace.android.syncmanager;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.projectplace.android.syncmanager.SyncFetch;
import com.projectplace.android.syncmanager.SyncManager;
import com.projectplace.android.syncmanager.SyncUpload;

public abstract class SyncObject {
    private SyncListener mManagerSyncListener;
    private SyncListener mSyncListener;
    private Object mError;
    private String mErrorMessage;
    private boolean mFailed;
    private boolean mStarted;
    private boolean mListenerCalled;
    private boolean mNeedsAccessToken = true;

    public abstract void onSave();

    public abstract void onStart();

    public abstract boolean isDone();

    void setManagerSyncListener(@NonNull SyncListener listener) {
        this.mManagerSyncListener = listener;
    }

    void reset() {
        this.mError = null;
        this.mFailed = false;
        this.mStarted = false;
        this.mListenerCalled = false;
    }

    void start() {
        this.mStarted = true;
        this.onStart();
    }

    private void setFailed(boolean failed) {
        this.mFailed = failed;
        this.checkIfDone();
    }

    protected void setErrorAndMessage(Object error, String errorMessage) {
        this.mErrorMessage = errorMessage;
        this.setError(error);
    }

    protected void setError(Object error) {
        this.mError = error;
        this.setFailed(true);
    }

    protected void checkIfDone() {
        if ((this.isFailed() || this.isDone()) && !this.mListenerCalled) {
            this.mListenerCalled = true;
            if (Looper.myLooper() == Looper.getMainLooper() || SyncManager.getTestListener() != null) {
                this.syncDone();
            } else {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        SyncObject.this.syncDone();
                    }
                });
            }
        }
    }

    private void syncDone() {
        if (this instanceof SyncFetch) {
            this.mManagerSyncListener.onFetchDone((SyncFetch)this);
        } else {
            this.mManagerSyncListener.onUploadDone((SyncUpload)this);
        }
    }

    public void setSyncListener(SyncListener listener) {
        this.mSyncListener = listener;
    }

    public SyncListener getSyncListener() {
        return this.mSyncListener;
    }

    protected void setNeedsAccessToken(boolean needsAccessToken) {
        this.mNeedsAccessToken = needsAccessToken;
    }

    public boolean needsAccessToken() {
        return this.mNeedsAccessToken;
    }

    public boolean isStarted() {
        return this.mStarted || this.mFailed;
    }

    public boolean isFailed() {
        return this.mFailed;
    }

    public boolean isSuccess() {
        return !this.mFailed;
    }

    public <T> T getError() {
        return (T)this.mError;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public static class SyncListenerAdapter
    implements SyncListener {
        @Override
        public void onFetchDone(SyncFetch syncFetch) {
        }

        @Override
        public void onUploadDone(SyncUpload syncUpload) {
        }
    }

    public static interface SyncListener {
        public void onFetchDone(SyncFetch var1);

        public void onUploadDone(SyncUpload var1);
    }
}

