/*
 * Decompiled with CFR 0.152.
 */
package com.projectplace.android.syncmanager;

import android.content.Context;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.util.Log;
import android.widget.Toast;
import com.projectplace.android.syncmanager.SyncFetch;
import com.projectplace.android.syncmanager.SyncObject;
import com.projectplace.android.syncmanager.SyncUpload;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class SyncManager
implements SyncObject.SyncListener {
    private static final String TAG = SyncManager.class.getSimpleName();
    private boolean mLogSyncEvents;
    private final ArrayList<SyncObject> mFetchList = new ArrayList();
    private final ArrayList<SyncObject> mUploadList = new ArrayList();
    private final ArrayList<SyncObject.SyncListener> mSyncListeners = new ArrayList();
    protected final Context mApplicationContext;
    private final Object mSyncLock = new Object();
    private SyncThread mSyncThread;
    private boolean mUsesAccessToken = true;
    private boolean mSyncStopped;
    private static SyncObject.SyncListener sTestListener;
    private static boolean sTestDisableNewSyncObjects;

    @WorkerThread
    protected abstract boolean shouldSyncObject(@NonNull SyncObject var1);

    @WorkerThread
    protected abstract boolean shouldRefreshAccessToken();

    @WorkerThread
    protected abstract void startRefreshAccessToken(@NonNull RefreshAccessTokenCallback var1);

    protected SyncManager(@NonNull Context context) {
        this.mApplicationContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSync() {
        Object object = this.mSyncLock;
        synchronized (object) {
            this.mSyncStopped = false;
            if (this.mSyncThread == null) {
                this.mSyncThread = new SyncThread();
                this.mSyncThread.start();
            }
            this.mSyncLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSync() {
        Object object = this.mSyncLock;
        synchronized (object) {
            this.mSyncStopped = true;
            this.mFetchList.clear();
            this.mUploadList.clear();
            this.mSyncLock.notify();
            this.mSyncThread = null;
        }
    }

    @VisibleForTesting
    public static void setTestListener(SyncObject.SyncListener testListener) {
        sTestListener = testListener;
    }

    @VisibleForTesting
    public static SyncObject.SyncListener getTestListener() {
        return sTestListener;
    }

    @VisibleForTesting
    public static void setTestDisableNewSyncObjects(boolean disable) {
        sTestDisableNewSyncObjects = disable;
    }

    public void setLogsEnabled(boolean enabled) {
        this.mLogSyncEvents = enabled;
    }

    public void setUsesAccessToken(boolean usesAccessToken) {
        this.mUsesAccessToken = usesAccessToken;
    }

    public void registerSyncListener(@NonNull SyncObject.SyncListener listener) {
        if (this.mSyncListeners.indexOf(listener) == -1) {
            this.mSyncListeners.add(listener);
        }
    }

    public void unregisterSyncListener(@NonNull SyncObject.SyncListener listener) {
        this.mSyncListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsIdenticalFetch(@NonNull SyncFetch fetch) {
        Object object = this.mSyncLock;
        synchronized (object) {
            for (int i = 0; i < this.mFetchList.size(); ++i) {
                SyncFetch tmpFetch = (SyncFetch)this.mFetchList.get(i);
                if (!tmpFetch.willFetchSameData(fetch)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch(@NonNull SyncFetch newFetch) {
        if (!sTestDisableNewSyncObjects) {
            Object object = this.mSyncLock;
            synchronized (object) {
                this.syncLog("(Fetch) New " + newFetch.getClass().getSimpleName());
                if (!this.containsIdenticalFetch(newFetch)) {
                    newFetch.setManagerSyncListener(this);
                    this.mFetchList.add(newFetch);
                    this.startSync();
                } else {
                    this.syncLog("(Fetch) Equal fetch object found, don't add");
                }
            }
        }
    }

    private void resetFetches(@NonNull SyncUpload newUpload) {
        for (SyncObject fetch : this.mFetchList) {
            if (!newUpload.shouldResetFetch((SyncFetch)fetch)) continue;
            ((SyncFetch)fetch).setShouldReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(final @NonNull SyncUpload newUpload) {
        if (!sTestDisableNewSyncObjects) {
            Object object = this.mSyncLock;
            synchronized (object) {
                this.syncLog("(Upload) New " + newUpload.getClass().getSimpleName());
                newUpload.setManagerSyncListener(this);
                this.resetFetches(newUpload);
                for (SyncObject upload : this.mUploadList) {
                    newUpload.updateRevertValues((SyncUpload)upload, true);
                }
                new AsyncTask<Void, Void, Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected Void doInBackground(Void ... params) {
                        newUpload.prepare();
                        Object object = SyncManager.this.mSyncLock;
                        synchronized (object) {
                            SyncManager.this.mUploadList.add(newUpload);
                        }
                        SyncManager.this.startSync();
                        return null;
                    }
                }.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUploadDone(final @NonNull SyncUpload syncUpload) {
        Object object = this.mSyncLock;
        synchronized (object) {
            this.syncLog("(onUploadDone) " + syncUpload.getClass().getSimpleName());
            this.mUploadList.remove(syncUpload);
            boolean conflict = false;
            if (syncUpload.isFailed()) {
                for (SyncObject upload : this.mUploadList) {
                    conflict = ((SyncUpload)upload).hasConflict(syncUpload);
                }
                this.showError(syncUpload);
            }
            final boolean shouldRevertIfFailed = !conflict;
            new AsyncTask<Void, Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground(Void ... params) {
                    if (syncUpload.isFailed()) {
                        if (shouldRevertIfFailed) {
                            SyncManager.this.syncLog("(onUploadDone) Failed to upload, reverting");
                            syncUpload.revert();
                        } else {
                            SyncManager.this.syncLog("(onUploadDone) Failed to upload but no revert as there is another conflicting upload ongoing");
                        }
                    } else {
                        Object object = SyncManager.this.mSyncLock;
                        synchronized (object) {
                            for (SyncObject upload : SyncManager.this.mUploadList) {
                                ((SyncUpload)upload).updateRevertValues(syncUpload, false);
                            }
                        }
                        syncUpload.onSave();
                    }
                    if (sTestListener != null) {
                        sTestListener.onUploadDone(syncUpload);
                    }
                    return null;
                }

                protected void onPostExecute(Void aVoid) {
                    for (SyncObject.SyncListener listener : SyncManager.this.mSyncListeners) {
                        listener.onUploadDone(syncUpload);
                    }
                    if (syncUpload.getSyncListener() != null) {
                        syncUpload.getSyncListener().onUploadDone(syncUpload);
                    }
                }
            }.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
        }
        this.startSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFetchDone(final @NonNull SyncFetch syncFetch) {
        if (this.mSyncStopped) {
            return;
        }
        this.syncLog("(onFetchDone) " + syncFetch.getClass().getSimpleName());
        if (syncFetch.isFailed()) {
            if (syncFetch.getRetries() != 0) {
                this.syncLog("(onFetchDone) SyncFetch failed, retrying. Retries left: " + (syncFetch.getRetries() - 1));
                syncFetch.reset();
                syncFetch.setRetries(syncFetch.getRetries() - 1);
                this.startSync();
            } else {
                Iterator<SyncObject.SyncListener> iterator = this.mSyncLock;
                synchronized (iterator) {
                    this.mFetchList.remove(syncFetch);
                }
                this.showError(syncFetch);
                if (sTestListener != null) {
                    sTestListener.onFetchDone(syncFetch);
                }
                for (SyncObject.SyncListener listener : this.mSyncListeners) {
                    listener.onFetchDone(syncFetch);
                }
                if (syncFetch.getSyncListener() != null) {
                    syncFetch.getSyncListener().onFetchDone(syncFetch);
                }
            }
        } else {
            Object object = this.mSyncLock;
            synchronized (object) {
                if (!syncFetch.shouldReset()) {
                    this.mFetchList.remove(syncFetch);
                    new AsyncTask<Void, Void, Void>(){

                        protected Void doInBackground(Void ... params) {
                            syncFetch.onSave();
                            if (sTestListener != null) {
                                sTestListener.onFetchDone(syncFetch);
                            }
                            return null;
                        }

                        protected void onPostExecute(Void isDone) {
                            for (SyncObject.SyncListener listener : SyncManager.this.mSyncListeners) {
                                listener.onFetchDone(syncFetch);
                            }
                            if (syncFetch.getSyncListener() != null) {
                                syncFetch.getSyncListener().onFetchDone(syncFetch);
                            }
                        }
                    }.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, (Object[])new Void[0]);
                } else {
                    this.syncLog("(onFetchDone) A conflict with an upload occurred, reset and the fetch will be done again: " + syncFetch.getClass().getSimpleName());
                    syncFetch.reset();
                    this.startSync();
                }
            }
        }
        this.syncLog("(onFetchDone) FetchList size: " + this.mFetchList.size());
    }

    protected void showError(@NonNull SyncObject syncObject) {
        if (syncObject.getErrorMessage() != null) {
            Toast.makeText((Context)this.mApplicationContext, (CharSequence)syncObject.getErrorMessage(), (int)1).show();
        }
    }

    private void syncLog(@NonNull String message) {
        if (this.mLogSyncEvents) {
            Log.d((String)TAG, (String)message);
        }
    }

    private class RefreshAccessTokenThread
    extends Thread {
        private static final int MAX_REFRESH_TRIES = 3;
        private static final int RESCHEDULE_BASE_TIME = 3000;
        private final Object mRefreshLock = new Object();
        private RefreshAccessTokenCallback mCallback;
        private boolean mRefreshDone;
        private boolean mRefreshing;
        private int mRefreshTries;

        public RefreshAccessTokenThread(RefreshAccessTokenCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void run() {
            while (!this.mRefreshDone) {
                this.refresh();
                this.waitRefreshLock();
                if (this.mRefreshDone) continue;
                int nextTryIn = this.mRefreshTries * 3000;
                SyncManager.this.syncLog("RefreshAccessTokenThread - Scheduling a new try in " + nextTryIn + " milliseconds");
                this.waitRefreshLock(nextTryIn);
            }
            SyncManager.this.syncLog("RefreshAccessTokenThread - Thread ending");
        }

        private void refresh() {
            if (this.mRefreshing) {
                return;
            }
            ++this.mRefreshTries;
            this.mRefreshing = true;
            SyncManager.this.syncLog("RefreshAccessTokenThread - Refreshing access token try number: " + this.mRefreshTries);
            SyncManager.this.startRefreshAccessToken(new RefreshAccessTokenCallback(){

                @Override
                public void refreshAccessTokenSuccess() {
                    SyncManager.this.syncLog("RefreshAccessTokenThread - Access token refresh success");
                    RefreshAccessTokenThread.this.mRefreshDone = true;
                    RefreshAccessTokenThread.this.mCallback.refreshAccessTokenSuccess();
                    RefreshAccessTokenThread.this.notifyRefreshLock();
                }

                @Override
                public void refreshAccessTokenFailed(Object error, boolean abortRetries) {
                    SyncManager.this.syncLog("RefreshAccessTokenThread - Access token refresh failed. Abort retries: " + abortRetries);
                    if (RefreshAccessTokenThread.this.mRefreshTries >= 3 || abortRetries) {
                        RefreshAccessTokenThread.this.mRefreshDone = true;
                        RefreshAccessTokenThread.this.mCallback.refreshAccessTokenFailed(error, abortRetries);
                    }
                    RefreshAccessTokenThread.this.mRefreshing = false;
                    RefreshAccessTokenThread.this.notifyRefreshLock();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitRefreshLock(long millis) {
            Object object = this.mRefreshLock;
            synchronized (object) {
                try {
                    this.mRefreshLock.wait(millis);
                    this.notifyRefreshLock();
                }
                catch (InterruptedException e) {
                    SyncManager.this.syncLog("RefreshAccessTokenThread - Interrupted");
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitRefreshLock() {
            Object object = this.mRefreshLock;
            synchronized (object) {
                try {
                    this.mRefreshLock.wait();
                }
                catch (InterruptedException e) {
                    SyncManager.this.syncLog("RefreshAccessTokenThread - Interrupted");
                    e.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyRefreshLock() {
            Object object = this.mRefreshLock;
            synchronized (object) {
                this.mRefreshLock.notify();
            }
        }
    }

    private class SyncThread
    extends Thread {
        private RefreshAccessTokenThread mRefreshAccessTokenThread;

        private SyncThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!SyncManager.this.mSyncStopped) {
                SyncManager.this.syncLog("Sync Thread - Check for sync object");
                Object object = SyncManager.this.mSyncLock;
                synchronized (object) {
                    SyncObject syncObject = this.getNextSyncObject();
                    if (syncObject != null && !SyncManager.this.shouldSyncObject(syncObject)) {
                        SyncManager.this.syncLog("Sync Thread - Should not sync object, remove without callback");
                        if (syncObject instanceof SyncFetch) {
                            SyncManager.this.mFetchList.remove(syncObject);
                        } else {
                            SyncManager.this.mUploadList.remove(syncObject);
                        }
                    } else if (SyncManager.this.mUsesAccessToken && syncObject != null && syncObject.needsAccessToken() && SyncManager.this.shouldRefreshAccessToken()) {
                        SyncManager.this.syncLog("Sync Thread - Access token needs to be refreshed");
                        if (this.mRefreshAccessTokenThread == null) {
                            this.mRefreshAccessTokenThread = new RefreshAccessTokenThread(new RefreshAccessTokenCallback(){

                                @Override
                                public void refreshAccessTokenSuccess() {
                                    SyncThread.this.mRefreshAccessTokenThread = null;
                                    SyncThread.this.notifySyncLock();
                                }

                                @Override
                                public void refreshAccessTokenFailed(Object error, boolean abortRetries) {
                                    SyncThread.this.mRefreshAccessTokenThread = null;
                                    SyncThread.this.failSyncObjectsThatNeedAccessToken(error);
                                }
                            });
                            this.mRefreshAccessTokenThread.start();
                        } else {
                            SyncManager.this.syncLog("Sync Thread - Refresh access token already in progress");
                        }
                        this.waitSyncLock("Sync Thread - Wait for refresh access token to finish");
                    } else {
                        if (syncObject != null) {
                            SyncManager.this.syncLog("Sync Thread - Start sync object: " + syncObject.getClass().getSimpleName());
                            syncObject.start();
                        }
                        if (!SyncManager.this.mSyncStopped && this.getNextSyncObject() == null) {
                            this.waitSyncLock("Sync Thread - Wait for sync objects");
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void failSyncObjectsThatNeedAccessToken(Object error) {
            Object object = SyncManager.this.mSyncLock;
            synchronized (object) {
                int i;
                for (i = SyncManager.this.mUploadList.size() - 1; i >= 0; --i) {
                    SyncObject upload = (SyncObject)SyncManager.this.mUploadList.get(i);
                    if (!upload.needsAccessToken()) continue;
                    upload.setError(error);
                }
                for (i = SyncManager.this.mFetchList.size() - 1; i >= 0; --i) {
                    SyncObject fetch = (SyncObject)SyncManager.this.mFetchList.get(i);
                    if (!fetch.needsAccessToken()) continue;
                    fetch.setError(error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SyncObject getNextSyncObject() {
            Object object = SyncManager.this.mSyncLock;
            synchronized (object) {
                for (SyncObject upload : SyncManager.this.mUploadList) {
                    if (upload.isStarted()) continue;
                    return upload;
                }
                if (SyncManager.this.mUploadList.size() == 0) {
                    for (SyncObject fetch : SyncManager.this.mFetchList) {
                        if (fetch.isStarted()) continue;
                        return fetch;
                    }
                }
            }
            return null;
        }

        private void waitSyncLock(String logMessage) {
            try {
                SyncManager.this.syncLog(logMessage);
                SyncManager.this.mSyncLock.wait();
            }
            catch (InterruptedException e) {
                SyncManager.this.syncLog("Sync Thread - Interrupted");
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifySyncLock() {
            Object object = SyncManager.this.mSyncLock;
            synchronized (object) {
                SyncManager.this.mSyncLock.notify();
            }
        }
    }

    public static interface RefreshAccessTokenCallback {
        public void refreshAccessTokenSuccess();

        public void refreshAccessTokenFailed(Object var1, boolean var2);
    }
}

