/*
 * Decompiled with CFR 0.152.
 */
package nnumbers.StringToNumber;

import nnumbers.NumberToString.NumberToString;
import references.references.BooleanReference;
import references.references.NumberArrayReference;
import references.references.NumberReference;
import references.references.StringReference;
import references.references.references;
import strstrings.strings.strings;

public class StringToNumber {
    public static boolean nCreateNumberFromDecimalStringWithCheck(char[] string, NumberReference decimalReference, StringReference errorMessage) {
        return StringToNumber.nCreateNumberFromStringWithCheck(string, 10.0, decimalReference, errorMessage);
    }

    public static double nCreateNumberFromDecimalString(char[] string) {
        NumberReference doubleReference = references.CreateNumberReference(0.0);
        StringReference stringReference = references.CreateStringReference("".toCharArray());
        StringToNumber.nCreateNumberFromStringWithCheck(string, 10.0, doubleReference, stringReference);
        double number = doubleReference.numberValue;
        StringToNumber.delete(doubleReference);
        StringToNumber.delete(stringReference);
        return number;
    }

    public static boolean nCreateNumberFromStringWithCheck(char[] string, double base, NumberReference numberReference, StringReference errorMessage) {
        boolean success;
        BooleanReference numberIsPositive = references.CreateBooleanReference(true);
        BooleanReference exponentIsPositive = references.CreateBooleanReference(true);
        NumberArrayReference beforePoint = new NumberArrayReference();
        NumberArrayReference afterPoint = new NumberArrayReference();
        NumberArrayReference exponent = new NumberArrayReference();
        if (base >= 2.0 && base <= 36.0) {
            success = StringToNumber.nExtractPartsFromNumberString(string, base, numberIsPositive, beforePoint, afterPoint, exponentIsPositive, exponent, errorMessage);
            if (success) {
                numberReference.numberValue = StringToNumber.nCreateNumberFromParts(base, numberIsPositive.booleanValue, beforePoint.numberArray, afterPoint.numberArray, exponentIsPositive.booleanValue, exponent.numberArray);
            }
        } else {
            success = false;
            errorMessage.string = "Base must be from 2 to 36.".toCharArray();
        }
        return success;
    }

    public static double nCreateNumberFromParts(double base, boolean numberIsPositive, double[] beforePoint, double[] afterPoint, boolean exponentIsPositive, double[] exponent) {
        double p;
        double i;
        double n = 0.0;
        for (i = 0.0; i < (double)beforePoint.length; i += 1.0) {
            p = beforePoint[(int)((double)beforePoint.length - i - 1.0)];
            n += p * Math.pow(base, i);
        }
        for (i = 0.0; i < (double)afterPoint.length; i += 1.0) {
            p = afterPoint[(int)i];
            n += p * Math.pow(base, -(i + 1.0));
        }
        if ((double)exponent.length > 0.0) {
            double e = 0.0;
            for (i = 0.0; i < (double)exponent.length; i += 1.0) {
                p = exponent[(int)((double)exponent.length - i - 1.0)];
                e += p * Math.pow(base, i);
            }
            if (!exponentIsPositive) {
                e = -e;
            }
            n *= Math.pow(base, e);
        }
        if (!numberIsPositive) {
            n = -n;
        }
        return n;
    }

    public static boolean nExtractPartsFromNumberString(char[] n, double base, BooleanReference numberIsPositive, NumberArrayReference beforePoint, NumberArrayReference afterPoint, BooleanReference exponentIsPositive, NumberArrayReference exponent, StringReference errorMessages) {
        boolean success;
        double i = 0.0;
        if (i < (double)n.length) {
            if (n[(int)i] == '-') {
                numberIsPositive.booleanValue = false;
                i += 1.0;
            } else if (n[(int)i] == '+') {
                numberIsPositive.booleanValue = true;
                i += 1.0;
            }
            success = StringToNumber.nExtractPartsFromNumberStringFromSign(n, base, i, beforePoint, afterPoint, exponentIsPositive, exponent, errorMessages);
        } else {
            success = false;
            errorMessages.string = "Number cannot have length zero.".toCharArray();
        }
        return success;
    }

    public static boolean nExtractPartsFromNumberStringFromSign(char[] n, double base, double i, NumberArrayReference beforePoint, NumberArrayReference afterPoint, BooleanReference exponentIsPositive, NumberArrayReference exponent, StringReference errorMessages) {
        boolean success;
        boolean done = false;
        double count = 0.0;
        while (i + count < (double)n.length && !done) {
            if (StringToNumber.nCharacterIsNumberCharacterInBase(n[(int)(i + count)], base)) {
                count += 1.0;
                continue;
            }
            done = true;
        }
        if (count >= 1.0) {
            beforePoint.numberArray = new double[(int)count];
            for (double j = 0.0; j < count; j += 1.0) {
                beforePoint.numberArray[(int)j] = StringToNumber.nGetNumberFromNumberCharacterForBase(n[(int)(i + j)], base);
            }
            if ((i += count) < (double)n.length) {
                success = StringToNumber.nExtractPartsFromNumberStringFromPointOrExponent(n, base, i, afterPoint, exponentIsPositive, exponent, errorMessages);
            } else {
                afterPoint.numberArray = new double[0];
                exponent.numberArray = new double[0];
                success = true;
            }
        } else {
            success = false;
            errorMessages.string = "Number must have at least one number after the optional sign.".toCharArray();
        }
        return success;
    }

    public static boolean nExtractPartsFromNumberStringFromPointOrExponent(char[] n, double base, double i, NumberArrayReference afterPoint, BooleanReference exponentIsPositive, NumberArrayReference exponent, StringReference errorMessages) {
        boolean success;
        if (n[(int)i] == '.') {
            if ((i += 1.0) < (double)n.length) {
                boolean done = false;
                double count = 0.0;
                while (i + count < (double)n.length && !done) {
                    if (StringToNumber.nCharacterIsNumberCharacterInBase(n[(int)(i + count)], base)) {
                        count += 1.0;
                        continue;
                    }
                    done = true;
                }
                if (count >= 1.0) {
                    afterPoint.numberArray = new double[(int)count];
                    for (double j = 0.0; j < count; j += 1.0) {
                        afterPoint.numberArray[(int)j] = StringToNumber.nGetNumberFromNumberCharacterForBase(n[(int)(i + j)], base);
                    }
                    if ((i += count) < (double)n.length) {
                        success = StringToNumber.nExtractPartsFromNumberStringFromExponent(n, base, i, exponentIsPositive, exponent, errorMessages);
                    } else {
                        exponent.numberArray = new double[0];
                        success = true;
                    }
                } else {
                    success = false;
                    errorMessages.string = "There must be at least one digit after the decimal point.".toCharArray();
                }
            } else {
                success = false;
                errorMessages.string = "There must be at least one digit after the decimal point.".toCharArray();
            }
        } else if (base <= 14.0 && (n[(int)i] == 'e' || n[(int)i] == 'E')) {
            if (i < (double)n.length) {
                success = StringToNumber.nExtractPartsFromNumberStringFromExponent(n, base, i, exponentIsPositive, exponent, errorMessages);
                afterPoint.numberArray = new double[0];
            } else {
                success = false;
                errorMessages.string = "There must be at least one digit after the exponent.".toCharArray();
            }
        } else {
            success = false;
            errorMessages.string = "Expected decimal point or exponent symbol.".toCharArray();
        }
        return success;
    }

    public static boolean nExtractPartsFromNumberStringFromExponent(char[] n, double base, double i, BooleanReference exponentIsPositive, NumberArrayReference exponent, StringReference errorMessages) {
        boolean success;
        if (base <= 14.0 && (n[(int)i] == 'e' || n[(int)i] == 'E')) {
            if ((i += 1.0) < (double)n.length) {
                if (n[(int)i] == '-') {
                    exponentIsPositive.booleanValue = false;
                    i += 1.0;
                } else if (n[(int)i] == '+') {
                    exponentIsPositive.booleanValue = true;
                    i += 1.0;
                }
                if (i < (double)n.length) {
                    boolean done = false;
                    double count = 0.0;
                    while (i + count < (double)n.length && !done) {
                        if (StringToNumber.nCharacterIsNumberCharacterInBase(n[(int)(i + count)], base)) {
                            count += 1.0;
                            continue;
                        }
                        done = true;
                    }
                    if (count >= 1.0) {
                        exponent.numberArray = new double[(int)count];
                        for (double j = 0.0; j < count; j += 1.0) {
                            exponent.numberArray[(int)j] = StringToNumber.nGetNumberFromNumberCharacterForBase(n[(int)(i + j)], base);
                        }
                        if ((i += count) == (double)n.length) {
                            success = true;
                        } else {
                            success = false;
                            errorMessages.string = "There cannot be any characters past the exponent of the number.".toCharArray();
                        }
                    } else {
                        success = false;
                        errorMessages.string = "There must be at least one digit after the decimal point.".toCharArray();
                    }
                } else {
                    success = false;
                    errorMessages.string = "There must be at least one digit after the exponent symbol.".toCharArray();
                }
            } else {
                success = false;
                errorMessages.string = "There must be at least one digit after the exponent symbol.".toCharArray();
            }
        } else {
            success = false;
            errorMessages.string = "Expected exponent symbol.".toCharArray();
        }
        return success;
    }

    public static double nGetNumberFromNumberCharacterForBase(char c, double base) {
        char[] numberTable = NumberToString.nGetDigitCharacterTable();
        double position = 0.0;
        for (double i = 0.0; i < base; i += 1.0) {
            if (numberTable[(int)i] != c) continue;
            position = i;
        }
        return position;
    }

    public static boolean nCharacterIsNumberCharacterInBase(char c, double base) {
        char[] numberTable = NumberToString.nGetDigitCharacterTable();
        boolean found = false;
        for (double i = 0.0; i < base; i += 1.0) {
            if (numberTable[(int)i] != c) continue;
            found = true;
        }
        return found;
    }

    public static double[] nStringToNumberArray(char[] str) {
        NumberArrayReference numberArrayReference = new NumberArrayReference();
        StringReference stringReference = new StringReference();
        StringToNumber.nStringToNumberArrayWithCheck(str, numberArrayReference, stringReference);
        double[] numbers = numberArrayReference.numberArray;
        StringToNumber.delete(numberArrayReference);
        StringToNumber.delete(stringReference);
        return numbers;
    }

    public static boolean nStringToNumberArrayWithCheck(char[] str, NumberArrayReference numberArrayReference, StringReference errorMessage) {
        StringReference[] numberStrings = strings.strSplitByString(str, ",".toCharArray());
        double[] numbers = new double[numberStrings.length];
        boolean success = true;
        NumberReference numberReference = new NumberReference();
        for (double i = 0.0; i < (double)numberStrings.length; i += 1.0) {
            char[] numberString = numberStrings[(int)i].string;
            char[] trimmedNumberString = strings.strTrim(numberString);
            success = StringToNumber.nCreateNumberFromDecimalStringWithCheck(trimmedNumberString, numberReference, errorMessage);
            numbers[(int)i] = numberReference.numberValue;
            references.FreeStringReference(numberStrings[(int)i]);
            StringToNumber.delete(trimmedNumberString);
        }
        StringToNumber.delete(numberStrings);
        StringToNumber.delete(numberReference);
        numberArrayReference.numberArray = numbers;
        return success;
    }

    public static void delete(Object object) {
    }
}

