/*
 * Decompiled with CFR 0.152.
 */
package JSON.writer;

import JSON.StringElementMaps.StringElementMaps;
import JSON.lengthComputer.lengthComputer;
import JSON.structures.Element;
import arrays.arrays.arrays;
import nnumbers.NumberToString.NumberToString;
import references.references.NumberReference;
import references.references.StringArrayReference;
import references.references.StringReference;
import references.references.references;
import strstrings.stream.stream;

public class writer {
    public static char[] WriteJSON(Element element) {
        double length = lengthComputer.ComputeJSONStringLength(element);
        char[] result = new char[(int)length];
        NumberReference index = references.CreateNumberReference(0.0);
        if (arrays.StringsEqual(element.type, "object".toCharArray())) {
            writer.WriteObject(element, result, index);
        } else if (arrays.StringsEqual(element.type, "string".toCharArray())) {
            writer.WriteString(element, result, index);
        } else if (arrays.StringsEqual(element.type, "array".toCharArray())) {
            writer.WriteArray(element, result, index);
        } else if (arrays.StringsEqual(element.type, "number".toCharArray())) {
            writer.WriteNumber(element, result, index);
        } else if (arrays.StringsEqual(element.type, "null".toCharArray())) {
            stream.strWriteStringToStingStream(result, index, "null".toCharArray());
        } else if (arrays.StringsEqual(element.type, "boolean".toCharArray())) {
            writer.WriteBooleanValue(element, result, index);
        }
        return result;
    }

    public static void WriteBooleanValue(Element element, char[] result, NumberReference index) {
        if (element.booleanValue) {
            stream.strWriteStringToStingStream(result, index, "true".toCharArray());
        } else {
            stream.strWriteStringToStingStream(result, index, "false".toCharArray());
        }
    }

    public static void WriteNumber(Element element, char[] result, NumberReference index) {
        char[] numberString = Math.abs(element.number) >= Math.pow(10.0, 15.0) || Math.abs(element.number) <= Math.pow(10.0, -15.0) ? NumberToString.nCreateStringScientificNotationDecimalFromNumber(element.number) : NumberToString.nCreateStringDecimalFromNumber(element.number);
        stream.strWriteStringToStingStream(result, index, numberString);
    }

    public static void WriteArray(Element element, char[] result, NumberReference index) {
        stream.strWriteStringToStingStream(result, index, "[".toCharArray());
        for (double i = 0.0; i < (double)element.array.length; i += 1.0) {
            Element arrayElement = element.array[(int)i];
            char[] s = writer.WriteJSON(arrayElement);
            stream.strWriteStringToStingStream(result, index, s);
            if (i + 1.0 == (double)element.array.length) continue;
            stream.strWriteStringToStingStream(result, index, ",".toCharArray());
        }
        stream.strWriteStringToStingStream(result, index, "]".toCharArray());
    }

    public static void WriteString(Element element, char[] result, NumberReference index) {
        stream.strWriteStringToStingStream(result, index, "\"".toCharArray());
        element.string = writer.JSONEscapeString(element.string);
        stream.strWriteStringToStingStream(result, index, element.string);
        stream.strWriteStringToStingStream(result, index, "\"".toCharArray());
    }

    public static char[] JSONEscapeString(char[] string) {
        double length = writer.JSONEscapedStringLength(string);
        char[] ns = new char[(int)length];
        NumberReference index = references.CreateNumberReference(0.0);
        NumberReference lettersReference = references.CreateNumberReference(0.0);
        for (double i = 0.0; i < (double)string.length; i += 1.0) {
            if (writer.JSONMustBeEscaped(string[(int)i], lettersReference)) {
                char[] escaped = writer.JSONEscapeCharacter(string[(int)i]);
                stream.strWriteStringToStingStream(ns, index, escaped);
                continue;
            }
            stream.strWriteCharacterToStingStream(ns, index, string[(int)i]);
        }
        return ns;
    }

    public static double JSONEscapedStringLength(char[] string) {
        NumberReference lettersReference = references.CreateNumberReference(0.0);
        double length = 0.0;
        for (double i = 0.0; i < (double)string.length; i += 1.0) {
            if (writer.JSONMustBeEscaped(string[(int)i], lettersReference)) {
                length += lettersReference.numberValue;
                continue;
            }
            length += 1.0;
        }
        return length;
    }

    public static char[] JSONEscapeCharacter(char c) {
        char[] escaped;
        double code = c;
        double q = 34.0;
        double rs = 92.0;
        double s = 47.0;
        double b = 8.0;
        double f = 12.0;
        double n = 10.0;
        double r = 13.0;
        double t = 9.0;
        StringReference hexNumber = new StringReference();
        if (code == q) {
            escaped = new char[]{'\\', '\"'};
        } else if (code == rs) {
            escaped = new char[]{'\\', '\\'};
        } else if (code == s) {
            escaped = new char[]{'\\', '/'};
        } else if (code == b) {
            escaped = new char[]{'\\', 'b'};
        } else if (code == f) {
            escaped = new char[]{'\\', 'f'};
        } else if (code == n) {
            escaped = new char[]{'\\', 'n'};
        } else if (code == r) {
            escaped = new char[]{'\\', 'r'};
        } else if (code == t) {
            escaped = new char[]{'\\', 't'};
        } else if (code >= 0.0 && code <= 31.0) {
            escaped = new char[6];
            escaped[0] = 92;
            escaped[1] = 117;
            escaped[2] = 48;
            escaped[3] = 48;
            NumberToString.nCreateStringFromNumberWithCheck(code, 16.0, hexNumber);
            if ((double)hexNumber.string.length == 1.0) {
                escaped[4] = 48;
                escaped[5] = hexNumber.string[0];
            } else if ((double)hexNumber.string.length == 2.0) {
                escaped[4] = hexNumber.string[0];
                escaped[5] = hexNumber.string[1];
            }
        } else {
            escaped = new char[]{c};
        }
        return escaped;
    }

    public static boolean JSONMustBeEscaped(char c, NumberReference letters) {
        double code = c;
        boolean mustBeEscaped = false;
        double q = 34.0;
        double rs = 92.0;
        double s = 47.0;
        double b = 8.0;
        double f = 12.0;
        double n = 10.0;
        double r = 13.0;
        double t = 9.0;
        if (code == q || code == rs || code == s || code == b || code == f || code == n || code == r || code == t) {
            mustBeEscaped = true;
            letters.numberValue = 2.0;
        } else if (code >= 0.0 && code <= 31.0) {
            mustBeEscaped = true;
            letters.numberValue = 6.0;
        } else if (code >= Math.pow(2.0, 16.0)) {
            mustBeEscaped = true;
            letters.numberValue = 6.0;
        }
        return mustBeEscaped;
    }

    public static void WriteObject(Element element, char[] result, NumberReference index) {
        stream.strWriteStringToStingStream(result, index, "{".toCharArray());
        StringArrayReference keys = StringElementMaps.GetStringElementMapKeySet(element.object);
        for (double i = 0.0; i < (double)keys.stringArray.length; i += 1.0) {
            char[] key = keys.stringArray[(int)i].string;
            key = writer.JSONEscapeString(key);
            Element objectElement = StringElementMaps.GetObjectValue(element.object, key);
            stream.strWriteStringToStingStream(result, index, "\"".toCharArray());
            stream.strWriteStringToStingStream(result, index, key);
            stream.strWriteStringToStingStream(result, index, "\"".toCharArray());
            stream.strWriteStringToStingStream(result, index, ":".toCharArray());
            char[] s = writer.WriteJSON(objectElement);
            stream.strWriteStringToStingStream(result, index, s);
            if (i + 1.0 == (double)keys.stringArray.length) continue;
            stream.strWriteStringToStingStream(result, index, ",".toCharArray());
        }
        stream.strWriteStringToStingStream(result, index, "}".toCharArray());
    }
}

