/*
 * Decompiled with CFR 0.152.
 */
package JSON.lengthComputer;

import JSON.StringElementMaps.StringElementMaps;
import JSON.structures.Element;
import JSON.writer.writer;
import arrays.arrays.arrays;
import nnumbers.NumberToString.NumberToString;
import references.references.StringArrayReference;

public class lengthComputer {
    public static double ComputeJSONStringLength(Element element) {
        double result = 0.0;
        if (arrays.StringsEqual(element.type, "object".toCharArray())) {
            result += lengthComputer.ComputeJSONObjectStringLength(element);
        } else if (arrays.StringsEqual(element.type, "string".toCharArray())) {
            result = writer.JSONEscapedStringLength(element.string) + 2.0;
        } else if (arrays.StringsEqual(element.type, "array".toCharArray())) {
            result += lengthComputer.ComputeJSONArrayStringLength(element);
        } else if (arrays.StringsEqual(element.type, "number".toCharArray())) {
            result += lengthComputer.ComputeJSONNumberStringLength(element);
        } else if (arrays.StringsEqual(element.type, "null".toCharArray())) {
            result += (double)"null".toCharArray().length;
        } else if (arrays.StringsEqual(element.type, "boolean".toCharArray())) {
            result += lengthComputer.ComputeJSONBooleanStringLength(element);
        }
        return result;
    }

    public static double ComputeJSONBooleanStringLength(Element element) {
        double result = element.booleanValue ? (double)"true".toCharArray().length : (double)"false".toCharArray().length;
        return result;
    }

    public static double ComputeJSONNumberStringLength(Element element) {
        double length;
        if (Math.abs(element.number) >= Math.pow(10.0, 15.0) || Math.abs(element.number) <= Math.pow(10.0, -15.0)) {
            char[] a = NumberToString.nCreateStringScientificNotationDecimalFromNumber(element.number);
            length = a.length;
        } else {
            char[] a = NumberToString.nCreateStringDecimalFromNumber(element.number);
            length = a.length;
        }
        return length;
    }

    public static double ComputeJSONArrayStringLength(Element element) {
        double length = 1.0;
        for (double i = 0.0; i < (double)element.array.length; i += 1.0) {
            Element arrayElement = element.array[(int)i];
            length += lengthComputer.ComputeJSONStringLength(arrayElement);
            if (i + 1.0 == (double)element.array.length) continue;
            length += 1.0;
        }
        return length += 1.0;
    }

    public static double ComputeJSONObjectStringLength(Element element) {
        double length = 1.0;
        StringArrayReference keys = StringElementMaps.GetStringElementMapKeySet(element.object);
        for (double i = 0.0; i < (double)keys.stringArray.length; i += 1.0) {
            char[] key = keys.stringArray[(int)i].string;
            Element objectElement = StringElementMaps.GetObjectValue(element.object, key);
            length += 1.0;
            length += writer.JSONEscapedStringLength(key);
            length += 1.0;
            length += 1.0;
            length += lengthComputer.ComputeJSONStringLength(objectElement);
            if (i + 1.0 == (double)keys.stringArray.length) continue;
            length += 1.0;
        }
        return length += 1.0;
    }
}

