/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.prqa.parsers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Rule
implements Serializable {
    private static final Pattern DIGITS = Pattern.compile("\\d+");
    private String ruleNumber;
    private int ruleTotalViolations;
    private Map<String, Integer> messages;
    private transient boolean calculated;

    public Rule(String ruleID, Map<String, Integer> messages) {
        this.ruleNumber = ruleID;
        this.messages = messages;
    }

    public Rule(String ruleID, int ruleTotalViolations) {
        this.ruleNumber = ruleID;
        this.ruleTotalViolations = ruleTotalViolations;
    }

    public static int calc(Map<String, Integer> map) {
        int count = 0;
        for (Integer value : map.values()) {
            count += value.intValue();
        }
        return count;
    }

    public String getRuleID() {
        return this.ruleNumber;
    }

    public int getRuleNumber() {
        Matcher matcher = DIGITS.matcher(this.ruleNumber);
        return matcher.find() ? Integer.parseInt(matcher.group()) : 0;
    }

    public Map<String, Integer> getMessages() {
        if (this.messages == null) {
            this.messages = new HashMap<String, Integer>();
            if (this.ruleTotalViolations > 0) {
                this.messages.put(this.ruleNumber, this.ruleTotalViolations);
            }
        }
        return this.messages;
    }

    public int getRuleTotalViolations() {
        if (!this.calculated) {
            this.ruleTotalViolations = Rule.calc(this.getMessages());
            this.calculated = true;
        }
        return this.ruleTotalViolations;
    }

    public int hashCode() {
        return this.ruleNumber.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rule) {
            Rule ruleObj = (Rule)obj;
            return Objects.equals(this.ruleNumber, ruleObj.ruleNumber);
        }
        return false;
    }
}

