/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.prqa.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.exceptions.PrqaParserException;

public abstract class ReportHtmlParser
implements Serializable {
    protected String fullReportPath;
    private static final Logger logger;
    public static final String LINE_SEPARATOR;

    public ReportHtmlParser() {
    }

    public ReportHtmlParser(String fullReportPath) {
        this.fullReportPath = fullReportPath;
    }

    public String getFullReportPath() {
        logger.finest(String.format("Returning value: %s", this.fullReportPath));
        return this.fullReportPath;
    }

    public void setFullReportPath(String fullReportPath) {
        logger.finest("Starting execution of method - setFullReportPath");
        this.fullReportPath = fullReportPath;
        logger.finest("Ending execution of method - setFullReportPath");
    }

    public String getParseFirstResult(Pattern pattern) throws PrqaException {
        logger.finest("Starting execution of method - getResult");
        String output = this.getFirstResult(this.parse(this.fullReportPath, pattern));
        logger.finest(String.format("Returning value: %s", output));
        return output;
    }

    public List<String> getParseResults(Pattern pattern) throws PrqaException {
        logger.finest("Starting execution of method - getResult");
        return this.parse(this.fullReportPath, pattern);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> parse(String path, Pattern pattern) throws PrqaParserException {
        FileInputStream fis;
        logger.finest("Starting execution of method - parse");
        ArrayList<String> result = new ArrayList<String>();
        File file = new File(path);
        logger.finest("Attempting to open filepath: " + file.getAbsolutePath());
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            logger.severe(String.format("Exception thrown type: %s; message: %s", ex.getClass(), ex.getMessage()));
            throw new PrqaParserException(ex);
        }
        logger.finest("File opened successfully!");
        try (InputStreamReader isr = new InputStreamReader(fis);
             BufferedReader source = new BufferedReader(isr);){
            String sourceLine = "";
            String report = "";
            logger.finest("Attempting to read the file...");
            while ((sourceLine = source.readLine()) != null) {
                Matcher match = pattern.matcher(report = report + sourceLine + LINE_SEPARATOR);
                if (!match.find()) continue;
                logger.finest("Match found!");
                result.add(match.group(1));
                logger.finest("Returning result:");
                for (String s : result) {
                    logger.finest(String.format("    %s", s));
                }
                ArrayList<String> arrayList = result;
                return arrayList;
            }
        }
        catch (IOException ex) {
            logger.severe(String.format("Exception thrown type: %s; message: %s", ex.getClass(), ex.getMessage()));
            throw new PrqaParserException(ex);
        }
        logger.finest("File read successfully!");
        logger.finest("Returning result:");
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            logger.finest(String.format("    %s", s));
        }
        return result;
    }

    public String getFirstResult(List<String> results) {
        logger.finest("Starting execution of method - getFirstResult");
        if (results.size() > 0) {
            String output = results.get(0);
            logger.finest(String.format("Returning value: %s", output));
            return output;
        }
        logger.finest("Collection is empty, returning null.");
        return null;
    }

    static {
        LINE_SEPARATOR = System.getProperty("line.separator");
        logger = Logger.getLogger(ReportHtmlParser.class.getName());
    }
}

