/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier.slave.filesystem;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import jenkins.MasterToSlaveFileCallable;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.reports.QAFrameworkReport;
import net.praqma.prqa.reports.ReportType;
import org.apache.commons.io.FileUtils;

public class CopyReportsToWorkspace
extends MasterToSlaveFileCallable<Boolean>
implements Serializable {
    private final String qaProject;
    private final String projectConfiguration;

    public CopyReportsToWorkspace(String qaProject, String projectConfiguration) {
        this.qaProject = qaProject;
        this.projectConfiguration = projectConfiguration;
    }

    public Boolean invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        String reportsPath;
        try {
            reportsPath = QAFrameworkReport.extractReportsPath(f.getAbsolutePath(), this.qaProject, this.projectConfiguration);
        }
        catch (PrqaException e) {
            throw new IOException(e);
        }
        File[] files = new File(reportsPath).listFiles();
        assert (files != null);
        for (File reportFile : files) {
            if (!this.containsReportName(reportFile.getName())) continue;
            FileUtils.copyFileToDirectory((File)reportFile, (File)f);
        }
        return Boolean.TRUE;
    }

    private boolean containsReportName(String fileName) {
        return fileName.contains(ReportType.CRR.name()) || fileName.contains(ReportType.SUR.name()) || fileName.contains(ReportType.RCR.name()) || fileName.contains(ReportType.MDR.name());
    }
}

