/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.notifier;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.Arrays;
import java.util.List;
import jenkins.model.Jenkins;
import net.praqma.jenkins.plugin.prqa.globalconfig.PRQAGlobalConfig;
import net.praqma.jenkins.plugin.prqa.globalconfig.QAVerifyServerConfiguration;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAFileProjectSource;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAFileProjectSourceDescriptor;
import net.praqma.jenkins.plugin.prqa.notifier.PRQAReportSourceDescriptor;
import net.praqma.jenkins.plugin.prqa.notifier.PostBuildActionSetup;
import net.praqma.jenkins.plugin.prqa.notifier.ThresholdSelectionDescriptor;
import net.praqma.jenkins.plugin.prqa.setup.QAFrameworkInstallationConfiguration;
import net.praqma.jenkins.plugin.prqa.threshold.AbstractThreshold;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class QAFrameworkPostBuildActionSetup
extends PostBuildActionSetup {
    public String qaInstallation;
    public String qaProject;
    public String unifiedProjectName;
    public boolean useCustomLicenseServer;
    public String customLicenseServerAddress;
    public boolean downloadUnifiedProjectDefinition;
    public boolean performCrossModuleAnalysis;
    public String cmaProjectName;
    public boolean reuseCmaDb;
    public boolean useDiskStorage;
    public boolean enableDependencyMode;
    public boolean generateReport;
    public boolean publishToQAV;
    public boolean loginToQAV;
    public List<String> chosenServers;
    public boolean uploadWhenStable;
    public String qaVerifyProjectName;
    public String uploadSnapshotName;
    public String buildNumber;
    public String uploadSourceCode;
    public boolean generateCrr;
    public boolean generateMdr;
    public boolean generateSup;
    public boolean analysisSettings;
    public boolean stopWhenFail;
    public boolean customCpuThreads;
    public String maxNumThreads;
    public boolean generatePreprocess;
    public boolean assembleSupportAnalytics;
    public boolean generateReportOnAnalysisError;
    public boolean addBuildNumber;
    public String projectConfiguration;

    @DataBoundConstructor
    public QAFrameworkPostBuildActionSetup(String qaInstallation, String qaProject, boolean useCustomLicenseServer, String customLicenseServerAddress, boolean downloadUnifiedProjectDefinition, String unifiedProjectName, boolean performCrossModuleAnalysis, String cmaProjectName, boolean reuseCmaDb, boolean useDiskStorage, boolean enableDependencyMode, boolean generateReport, boolean publishToQAV, boolean loginToQAV, List<String> chosenServers, boolean uploadWhenStable, String qaVerifyProjectName, String uploadSnapshotName, String buildNumber, String uploadSourceCode, boolean generateCrr, boolean generateMdr, boolean generateSup, boolean analysisSettings, boolean stopWhenFail, boolean customCpuThreads, String maxNumThreads, boolean generatePreprocess, boolean assembleSupportAnalytics, boolean generateReportOnAnalysisError, boolean addBuildNumber, String projectConfiguration) {
        this.qaInstallation = qaInstallation;
        this.qaProject = qaProject;
        this.useCustomLicenseServer = useCustomLicenseServer;
        this.customLicenseServerAddress = customLicenseServerAddress;
        this.downloadUnifiedProjectDefinition = downloadUnifiedProjectDefinition;
        this.unifiedProjectName = unifiedProjectName;
        this.performCrossModuleAnalysis = performCrossModuleAnalysis;
        this.cmaProjectName = cmaProjectName;
        this.reuseCmaDb = reuseCmaDb;
        this.enableDependencyMode = enableDependencyMode;
        this.generateReport = generateReport;
        this.publishToQAV = publishToQAV;
        this.loginToQAV = loginToQAV;
        this.chosenServers = chosenServers;
        this.uploadWhenStable = uploadWhenStable;
        this.qaVerifyProjectName = qaVerifyProjectName;
        this.uploadSnapshotName = uploadSnapshotName;
        this.buildNumber = buildNumber;
        this.uploadSourceCode = uploadSourceCode;
        this.generateCrr = generateCrr;
        this.generateMdr = generateMdr;
        this.generateSup = generateSup;
        this.analysisSettings = analysisSettings;
        this.stopWhenFail = stopWhenFail;
        this.useDiskStorage = useDiskStorage;
        this.customCpuThreads = customCpuThreads;
        this.maxNumThreads = maxNumThreads;
        this.generatePreprocess = generatePreprocess;
        this.assembleSupportAnalytics = assembleSupportAnalytics;
        this.generateReportOnAnalysisError = generateReportOnAnalysisError;
        this.addBuildNumber = addBuildNumber;
        this.projectConfiguration = projectConfiguration;
    }

    public List<String> getChosenServers() {
        return this.chosenServers;
    }

    public void setChosenServers(List<String> chosenServers) {
        this.chosenServers = chosenServers;
    }

    public boolean isPublishToQAV() {
        return this.publishToQAV;
    }

    public boolean isLoginToQAV() {
        return this.loginToQAV;
    }

    public boolean isUploadWhenStable() {
        return this.uploadWhenStable;
    }

    public void setPublishToQAV(boolean publishToQAV) {
        this.publishToQAV = publishToQAV;
    }

    public void setLoginToQAV(boolean loginToQAV) {
        this.loginToQAV = loginToQAV;
    }

    public void setQaInstallation(String qaInstallation) {
        this.qaInstallation = qaInstallation;
    }

    public void setQaProject(String qaProject) {
        this.qaProject = qaProject;
    }

    public void setDownloadUnifiedProjectDefinition(boolean downloadUnifiedProjectDefinition) {
        this.downloadUnifiedProjectDefinition = downloadUnifiedProjectDefinition;
    }

    public void setPerformCrossModuleAnalysis(boolean performCrossModuleAnalysis) {
        this.performCrossModuleAnalysis = performCrossModuleAnalysis;
    }

    public void setEnableDependencyMode(boolean enableDependencyMode) {
        this.enableDependencyMode = enableDependencyMode;
    }

    public void setUploadWhenStable(boolean uploadWhenStable) {
        this.uploadWhenStable = uploadWhenStable;
    }

    public String getQaInstallation() {
        return this.qaInstallation;
    }

    public String getQaProject() {
        return this.qaProject;
    }

    public String getUnifiedProjectName() {
        return this.unifiedProjectName;
    }

    public String getVerifySnapshotName() {
        return this.uploadSnapshotName;
    }

    public void setUnifiedProjectName(String uProjectName) {
        this.unifiedProjectName = uProjectName;
    }

    public boolean isDownloadUnifiedProjectDefinition() {
        return this.downloadUnifiedProjectDefinition;
    }

    public boolean isPerformCrossModuleAnalysis() {
        return this.performCrossModuleAnalysis;
    }

    public boolean isEnableDependencyMode() {
        return this.enableDependencyMode;
    }

    public boolean isGenerateReport() {
        return this.generateReport;
    }

    public void setGenerateReport(boolean generateReport) {
        this.generateReport = generateReport;
    }

    public String getUploadSourceCode() {
        return this.uploadSourceCode;
    }

    public String getVerifyProjectName() {
        return this.qaVerifyProjectName;
    }

    public boolean isGenerateCrr() {
        return this.generateCrr;
    }

    public boolean isGenerateMdr() {
        return this.generateMdr;
    }

    public boolean isGenerateSup() {
        return this.generateSup;
    }

    public void setGenerateCrr(boolean generateCrr) {
        this.generateCrr = generateCrr;
    }

    public void setGenerateMdr(boolean generateMdr) {
        this.generateMdr = generateMdr;
    }

    public void setGenerateSup(boolean generateSup) {
        this.generateSup = generateSup;
    }

    public void setUploadSourceCode(String uploadSource) {
        this.uploadSourceCode = uploadSource;
    }

    public void setVerifyProjectName(String qaVerifyProject) {
        this.qaVerifyProjectName = qaVerifyProject;
    }

    public void setVerifySnapshotName(String qaVerifySnapshotName) {
        this.uploadSnapshotName = qaVerifySnapshotName;
    }

    public void setAnalysisSettings(boolean analysisSettings) {
        this.analysisSettings = analysisSettings;
    }

    public void setStopWhenFail(boolean stopWhenFail) {
        this.stopWhenFail = stopWhenFail;
    }

    public void setGeneratePreprocess(boolean generatePreprocess) {
        this.generatePreprocess = generatePreprocess;
    }

    public void setAssembleSupportAnalytics(boolean assembleSupportAnalytics) {
        this.assembleSupportAnalytics = assembleSupportAnalytics;
    }

    public void setReuseCmaDb(boolean reuseCmaDb) {
        this.reuseCmaDb = reuseCmaDb;
    }

    public void setUseDiskStorage(boolean useDiskStorage) {
        this.useDiskStorage = useDiskStorage;
    }

    public void setMaxNumThreads(String maxNumThreads) {
        this.maxNumThreads = maxNumThreads;
    }

    public void setCustomCpuThreads(boolean customCpuThreads) {
        this.customCpuThreads = customCpuThreads;
    }

    public boolean isAnalysisSettings() {
        return this.analysisSettings;
    }

    public boolean isStopWhenFail() {
        return this.stopWhenFail;
    }

    public boolean isGeneratePreprocess() {
        return this.generatePreprocess;
    }

    public boolean isAssembleSupportAnalytics() {
        return this.assembleSupportAnalytics;
    }

    public boolean isGenerateReportOnAnalysisError() {
        return this.generateReportOnAnalysisError;
    }

    public boolean isReuseCmaDb() {
        return this.reuseCmaDb;
    }

    public boolean isUseDiskStorage() {
        return this.useDiskStorage;
    }

    public String getMaxNumThreads() {
        return this.maxNumThreads;
    }

    public boolean isCustomCpuThreads() {
        return this.customCpuThreads;
    }

    public String getCmaProjectName() {
        return this.cmaProjectName;
    }

    public void setCmaProjectName(String cmaProjectName) {
        this.cmaProjectName = cmaProjectName;
    }

    public boolean isAddBuildNumber() {
        return this.addBuildNumber;
    }

    public void setAddBuildNumber(boolean addBuildNumber) {
        this.addBuildNumber = addBuildNumber;
    }

    public String getProjectConfiguration() {
        return this.projectConfiguration;
    }

    public void setProjectConfiguration(String projectConfiguration) {
        this.projectConfiguration = projectConfiguration;
    }

    @Extension
    public static final class DescriptorImpl
    extends PRQAReportSourceDescriptor<QAFrameworkPostBuildActionSetup> {
        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            this.save();
            return super.configure(req, json);
        }

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "PRQA\u00b7Framework";
        }

        public FormValidation doCheckCustomLicenseServerAddress(@QueryParameter String customLicenseServerAddress) {
            String serverRegex = "^(\\d{1,5})@(.+)$";
            if (StringUtils.isBlank((String)customLicenseServerAddress)) {
                return FormValidation.error((String)"Custom license server address must not be empty");
            }
            if (!customLicenseServerAddress.matches("^(\\d{1,5})@(.+)$")) {
                return FormValidation.error((String)"License server format must be <port>@<host>");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQAInstallation(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Error");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillUploadSourceCodeItems() {
            ListBoxModel SourceOption = new ListBoxModel();
            SourceOption.add("None", "NONE");
            SourceOption.add("All", "ALL");
            SourceOption.add("Only not in VCS", "NOT_IN_VCS");
            return SourceOption;
        }

        public FormValidation doCheckCmaProjectName(@QueryParameter String cmaProjectName) {
            if (StringUtils.isBlank((String)cmaProjectName)) {
                return FormValidation.errorWithMarkup((String)"CMA project name should not be empty!");
            }
            if (!cmaProjectName.matches("^[a-zA-Z0-9_-{}()$%]+$")) {
                return FormValidation.errorWithMarkup((String)"CMA project name is not valid [characters allowed: a-zA-Z0-9-_{}()$%]");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUnifiedProjectName(@QueryParameter String unifiedProjectName) {
            if (StringUtils.isBlank((String)unifiedProjectName)) {
                return FormValidation.errorWithMarkup((String)"Unified Project name should not be empty!");
            }
            if (!unifiedProjectName.matches("^[a-zA-Z0-9_-{}()$%]+$")) {
                return FormValidation.errorWithMarkup((String)"Unified project name is not valid [characters allowed: a-zA-Z0-9-_{}()$%]");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUploadSnapshotName(@QueryParameter String uploadSnapshotName) {
            if (StringUtils.isBlank((String)uploadSnapshotName)) {
                return FormValidation.ok();
            }
            if (!uploadSnapshotName.matches("^[a-zA-Z0-9_-{}()$%]+$")) {
                return FormValidation.errorWithMarkup((String)"Snapshot name is not valid [characters allowed: a-zA-Z0-9-_{}()$%]");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckQaVerifyProjectName(@QueryParameter String qaVerifyProjectName) {
            if (StringUtils.isBlank((String)qaVerifyProjectName)) {
                return FormValidation.errorWithMarkup((String)"Project name should not be empty!");
            }
            if (!qaVerifyProjectName.matches("^[a-zA-Z0-9_-{}()$%]+$")) {
                return FormValidation.errorWithMarkup((String)"Project name is not valid [characters allowed: a-zA-Z0-9-_{}()$%]");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMaxNumThreads(@QueryParameter String maxNumThreads) {
            Integer minValue = 0;
            if (StringUtils.isBlank((String)maxNumThreads)) {
                return FormValidation.errorWithMarkup((String)Messages.PRQANotifier_NotEmptyValue("Max. Number of Threads for Analysis"));
            }
            try {
                Integer parsedValue = Integer.parseInt(maxNumThreads);
                if (parsedValue <= minValue) {
                    return FormValidation.error((String)Messages.PRQANotifier_WrongIntegerGreatherThan(minValue));
                }
            }
            catch (NumberFormatException ex) {
                return FormValidation.error((String)Messages.PRQANotifier_UseInteger());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillQaInstallationItems() {
            ListBoxModel model = new ListBoxModel();
            for (QAFrameworkInstallationConfiguration suiteQAFramework : this.getQAFrameworkTools()) {
                model.add(suiteQAFramework.getName());
            }
            return model;
        }

        public List<QAFrameworkInstallationConfiguration> getQAFrameworkTools() {
            Jenkins jenkins = Jenkins.get();
            QAFrameworkInstallationConfiguration[] prqaInstallations = (QAFrameworkInstallationConfiguration[])((QAFrameworkInstallationConfiguration.DescriptorImpl)jenkins.getDescriptorByType(QAFrameworkInstallationConfiguration.DescriptorImpl.class)).getInstallations();
            return Arrays.asList(prqaInstallations);
        }

        public List<ThresholdSelectionDescriptor<?>> getThresholdSelections() {
            return AbstractThreshold.getDescriptors();
        }

        public List<QAVerifyServerConfiguration> getServers() {
            return PRQAGlobalConfig.get().getServers();
        }

        public List<PRQAFileProjectSourceDescriptor<?>> getFileProjectSources() {
            return PRQAFileProjectSource.getDescriptors();
        }
    }
}

