/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.globalconfig;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.praqma.jenkins.plugin.prqa.notifier.Messages;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class QAVerifyServerConfiguration
extends AbstractDescribableImpl<QAVerifyServerConfiguration>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String configurationName = "Configuration name";
    private String hostName;
    private Integer portNumber;
    private String userName;
    private Secret password;
    private String protocol;
    private Integer viewerPortNumber = 8080;
    private String externalUrl;

    @DataBoundConstructor
    public QAVerifyServerConfiguration(String configurationName, String hostName, Integer portNumber, String userName, Secret password, String protocol, Integer viewerPortNumber, String externalUrl) {
        this.configurationName = configurationName;
        this.hostName = hostName;
        this.password = password;
        this.userName = userName;
        this.portNumber = portNumber;
        this.protocol = protocol;
        this.viewerPortNumber = viewerPortNumber;
        this.externalUrl = externalUrl;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    @DataBoundSetter
    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getHostName() {
        return this.hostName;
    }

    @DataBoundSetter
    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public Integer getPortNumber() {
        return this.portNumber;
    }

    @DataBoundSetter
    public void setPortNumber(Integer portNumber) {
        this.portNumber = portNumber;
    }

    public String getUserName() {
        return this.userName;
    }

    @DataBoundSetter
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public Secret getPassword() {
        return this.password;
    }

    @DataBoundSetter
    public void setPassword(Secret password) {
        this.password = password;
    }

    public String toString() {
        return this.configurationName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QAVerifyServerConfiguration that = (QAVerifyServerConfiguration)o;
        return Objects.equals(this.getConfigurationName(), that.getConfigurationName());
    }

    public int hashCode() {
        return Objects.hash(this.getConfigurationName());
    }

    public String getFullUrl() {
        return this.protocol + "://" + this.hostName + ":" + this.viewerPortNumber;
    }

    public String getFullExternalUrl() {
        if (StringUtils.isEmpty((String)this.externalUrl)) {
            return this.getFullUrl();
        }
        return this.externalUrl;
    }

    public Integer getViewerPortNumber() {
        return this.viewerPortNumber;
    }

    @DataBoundSetter
    public void setViewerPortNumber(Integer viewerPortNumber) {
        this.viewerPortNumber = viewerPortNumber;
    }

    public String getProtocol() {
        return this.protocol;
    }

    @DataBoundSetter
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    @DataBoundSetter
    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<QAVerifyServerConfiguration> {
        public DescriptorImpl() {
            super(QAVerifyServerConfiguration.class);
            this.load();
        }

        public ViewServerProtocol[] getViewServerProtocols() {
            return ViewServerProtocol.values();
        }

        @Nonnull
        public String getDisplayName() {
            return "QA\u00b7Verify Server";
        }

        public FormValidation doCheckConfigurationName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckHostName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckPortNumber(@QueryParameter String value) {
            return this.checkValidPort(value);
        }

        public FormValidation doCheckUserName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckViewerPortNumber(@QueryParameter String value) {
            return this.checkValidPort(value);
        }

        public FormValidation doCheckExternalUrl(@QueryParameter String value) {
            if (StringUtils.isEmpty((String)value)) {
                return FormValidation.ok();
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        private FormValidation checkValidPort(@QueryParameter String value) {
            Integer valueOf;
            try {
                valueOf = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                valueOf = -1;
            }
            if (valueOf <= 0 || valueOf > 65535) {
                return FormValidation.error((String)Messages.QAVerifyServerConfiguration_InvalidPort());
            }
            return FormValidation.ok();
        }
    }

    public static enum ViewServerProtocol {
        http,
        https;

    }
}

