/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa.globalconfig;

import hudson.Extension;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.praqma.jenkins.plugin.prqa.globalconfig.QAVerifyServerConfiguration;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class PRQAGlobalConfig
extends GlobalConfiguration {
    private List<QAVerifyServerConfiguration> servers = new ArrayList<QAVerifyServerConfiguration>();

    @Inject
    public PRQAGlobalConfig() {
        this.load();
    }

    public PRQAGlobalConfig(List<QAVerifyServerConfiguration> servers) {
        this.servers = servers;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        boolean clean_servers;
        boolean bl = clean_servers = json.get("servers") == null && this.servers.size() > 0;
        if (clean_servers) {
            json.put("servers", (Object)new JSONObject());
        }
        req.bindJSON((Object)this, json);
        this.save();
        boolean result = super.configure(req, json);
        if (clean_servers) {
            this.servers.clear();
        }
        return result;
    }

    public static PRQAGlobalConfig get() {
        return (PRQAGlobalConfig)((Object)GlobalConfiguration.all().get(PRQAGlobalConfig.class));
    }

    public List<QAVerifyServerConfiguration> getServers() {
        return this.servers;
    }

    public void setServers(List<QAVerifyServerConfiguration> servers) {
        this.servers = servers;
    }

    public QAVerifyServerConfiguration getConfigurationByName(String name) {
        for (QAVerifyServerConfiguration conf : this.getServers()) {
            if (!conf.getConfigurationName().equals(name)) continue;
            return conf;
        }
        return null;
    }

    public Collection<QAVerifyServerConfiguration> getConfigurationsByNames(Collection<String> names) {
        if (names == null) {
            return new ArrayList<QAVerifyServerConfiguration>();
        }
        ArrayList<QAVerifyServerConfiguration> configurations = new ArrayList<QAVerifyServerConfiguration>(names.size());
        for (QAVerifyServerConfiguration conf : this.getServers()) {
            if (!names.contains(conf.getConfigurationName())) continue;
            configurations.add(conf);
        }
        return configurations;
    }

    public List<Descriptor> descriptors() {
        return Collections.singletonList(Jenkins.get().getDescriptor(QAVerifyServerConfiguration.class));
    }
}

