/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa;

import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import net.praqma.prqa.PRQAApplicationSettings;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.reports.QAFrameworkReport;
import net.prqma.prqa.qaframework.QaFrameworkReportSettings;
import org.apache.commons.lang.StringUtils;

public class QAFrameworkRemoteReportUpload
extends MasterToSlaveFileCallable<Void>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private QAFrameworkReport report;
    private BuildListener listener;
    private QaFrameworkReportSettings reportSetting;

    public QAFrameworkRemoteReportUpload(QAFrameworkReport report, BuildListener listener) {
        this.report = report;
        this.listener = listener;
    }

    private Map<String, String> expandEnvironment(Map<String, String> environment, QaFrameworkReportSettings reportSetting) {
        this.reportSetting = reportSetting;
        if (environment == null) {
            return Collections.emptyMap();
        }
        environment.put("QAFBINPATH", PRQAApplicationSettings.addSlash(environment.get("QAFINSTALLPATH"), File.separator) + "common" + File.separator + "bin");
        return environment;
    }

    public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        Map<String, String> expandedEnvironment = this.expandEnvironment(this.report.getEnvironment(), this.report.getSettings());
        this.report.setEnvironment(expandedEnvironment);
        this.report.setWorkspace(f);
        PrintStream out = this.listener.getLogger();
        try {
            if (StringUtils.isBlank((String)this.report.getSettings().getQaInstallation())) {
                throw new PrqaException("Incorrect configuration of QA framework installation!");
            }
            if (this.reportSetting.isLoginToQAV() && this.reportSetting.isPublishToQAV()) {
                this.report.uploadQacli(out);
            }
            return null;
        }
        catch (PrqaException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }
}

