/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.plugin.prqa;

import hudson.model.BuildListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import net.praqma.prqa.PRQAApplicationSettings;
import net.praqma.prqa.exceptions.PrqaException;
import net.praqma.prqa.reports.QAFrameworkReport;
import net.praqma.prqa.reports.ReportType;
import net.praqma.prqa.status.PRQAComplianceStatus;
import net.prqma.prqa.qaframework.QaFrameworkReportSettings;
import org.apache.commons.lang.StringUtils;

public class QAFrameworkRemoteReport
extends MasterToSlaveFileCallable<PRQAComplianceStatus> {
    private static final long serialVersionUID = 1L;
    private QAFrameworkReport report;
    private BuildListener listener;
    private QaFrameworkReportSettings reportSetting;

    public QAFrameworkRemoteReport(QAFrameworkReport report, BuildListener listener) {
        this.report = report;
        this.listener = listener;
    }

    private Map<String, String> expandEnvironment(Map<String, String> environment, QaFrameworkReportSettings reportSetting) {
        this.reportSetting = reportSetting;
        if (environment == null) {
            return Collections.emptyMap();
        }
        environment.put("QAFBINPATH", PRQAApplicationSettings.addSlash(environment.get("QAFINSTALLPATH"), File.separator) + "common" + File.separator + "bin");
        return environment;
    }

    public PRQAComplianceStatus invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        Map<String, String> expandedEnvironment = this.expandEnvironment(this.report.getEnvironment(), this.report.getSettings());
        this.report.setEnvironment(expandedEnvironment);
        this.report.setWorkspace(f);
        PrintStream out = this.listener.getLogger();
        out.println("Workspace from invoke:" + f.getAbsolutePath());
        boolean customServerWasApplied = false;
        try {
            block21: {
                block20: {
                    customServerWasApplied = this.report.applyCustomLicenseServer(out);
                    if (StringUtils.isBlank((String)this.report.getSettings().getQaInstallation())) {
                        throw new PrqaException("Incorrect configuration of QA framework installation!");
                    }
                    if (this.reportSetting.isLoginToQAV() && this.reportSetting.isPullUnifiedProject()) {
                        this.report.pullUnifyProjectQacli(out);
                    }
                    if (this.reportSetting.isAnalysisSettings() && this.reportSetting.isCustomCpuThreads()) {
                        this.report.applyCpuThreads(out);
                    }
                    try {
                        this.report.analyzeQacli("-cf", out);
                    }
                    catch (PrqaException e) {
                        if (this.reportSetting.isGenerateReportOnAnalysisError()) break block20;
                        out.println("Failed to perform analysis. Will not continue with report generation");
                        throw e;
                    }
                }
                if (this.reportSetting.isQaCrossModuleAnalysis()) {
                    try {
                        this.report.cmaAnalysisQacli(out);
                    }
                    catch (PrqaException e) {
                        if (this.reportSetting.isGenerateReportOnAnalysisError()) break block21;
                        out.println("Failed to perform analysis. Will not continue with report generation");
                        throw e;
                    }
                }
            }
            if (this.reportSetting.isGenCrReport()) {
                this.report.reportQacli(ReportType.CRR.name(), out);
            }
            if (this.reportSetting.isGenMdReport()) {
                this.report.reportQacli(ReportType.MDR.name(), out);
            }
            if (this.reportSetting.isGenSupReport()) {
                this.report.reportQacli(ReportType.SUR.name(), out);
            }
            this.report.reportQacli(ReportType.RCR.name(), out);
            PRQAComplianceStatus e = this.report.getComplianceStatus(out);
            return e;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        finally {
            try {
                this.report.unsetCustomLicenseServer(customServerWasApplied, out);
            }
            catch (PrqaException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

