/*
 * Decompiled with CFR 0.152.
 */
package com.profesorfalken.jpowershell;

import com.profesorfalken.jpowershell.PowerShellCommandProcessor;
import com.profesorfalken.jpowershell.PowerShellNotAvailableException;
import com.profesorfalken.jpowershell.PowerShellResponse;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerShell {
    private Process p;
    private PrintWriter commandWriter;
    private boolean closed = false;
    private ExecutorService threadpool;
    private static final int MAX_THREADS = 3;
    static final int WAIT_PAUSE = 10;
    static final int MAX_WAIT = 10000;

    private PowerShell() {
    }

    private PowerShell initalize() throws PowerShellNotAvailableException {
        ProcessBuilder pb = new ProcessBuilder("powershell.exe", "-NoExit", "-Command", "-");
        try {
            this.p = pb.start();
        }
        catch (IOException ex) {
            throw new PowerShellNotAvailableException("Cannot execute PowerShell.exe. Please make sure that it is installed in your system", ex);
        }
        this.commandWriter = new PrintWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(this.p.getOutputStream())), true);
        this.threadpool = Executors.newFixedThreadPool(3);
        return this;
    }

    public static PowerShell openSession() throws PowerShellNotAvailableException {
        PowerShell powerShell = new PowerShell();
        return powerShell.initalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PowerShellResponse executeCommand(String command) {
        PowerShellCommandProcessor commandProcessor = new PowerShellCommandProcessor("standard", this.p.getInputStream());
        PowerShellCommandProcessor commandProcessorError = new PowerShellCommandProcessor("error", this.p.getErrorStream());
        String commandOutput = "";
        boolean isError = false;
        Future result = this.threadpool.submit(commandProcessor);
        Future resultError = this.threadpool.submit(commandProcessorError);
        this.commandWriter.println(command);
        try {
            while (!result.isDone() && !resultError.isDone()) {
                Thread.sleep(10L);
            }
            if (result.isDone()) {
                commandOutput = (String)result.get();
            } else {
                isError = true;
                commandOutput = (String)resultError.get();
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when processing PowerShell command", ex);
        }
        finally {
            commandProcessor.close();
            commandProcessorError.close();
        }
        return new PowerShellResponse(isError, commandOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        block18: {
            if (!this.closed) {
                Future<String> closeTask = this.threadpool.submit(new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        PowerShell.this.commandWriter.println("exit");
                        PowerShell.this.p.waitFor();
                        return "OK";
                    }
                });
                PowerShell.waitUntilClose(closeTask);
                Object var3_3 = null;
                try {
                    this.p.getInputStream().close();
                    this.p.getErrorStream().close();
                }
                catch (IOException ex2) {
                    Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing streams", ex2);
                }
                this.commandWriter.close();
                if (this.threadpool != null) {
                    try {
                        this.threadpool.shutdownNow();
                        this.threadpool.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException ex2) {
                        Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when shutting thread pool", ex2);
                    }
                }
                this.closed = true;
                {
                    break block18;
                    catch (InterruptedException ex) {
                        Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing PowerShell", ex);
                        Object var3_4 = null;
                        try {
                            this.p.getInputStream().close();
                            this.p.getErrorStream().close();
                        }
                        catch (IOException ex2) {
                            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing streams", ex2);
                        }
                        this.commandWriter.close();
                        if (this.threadpool != null) {
                            try {
                                this.threadpool.shutdownNow();
                                this.threadpool.awaitTermination(5L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ex2) {
                                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when shutting thread pool", ex2);
                            }
                        }
                        this.closed = true;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    try {
                        this.p.getInputStream().close();
                        this.p.getErrorStream().close();
                    }
                    catch (IOException ex2) {
                        Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when closing streams", ex2);
                    }
                    this.commandWriter.close();
                    if (this.threadpool != null) {
                        try {
                            this.threadpool.shutdownNow();
                            this.threadpool.awaitTermination(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException ex2) {
                            Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when when shutting thread pool", ex2);
                        }
                    }
                    this.closed = true;
                    throw throwable;
                }
            }
        }
    }

    private static void waitUntilClose(Future<String> task) throws InterruptedException {
        int closingTime = 0;
        while (!task.isDone()) {
            if (closingTime > 10000) {
                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "Unexpected error when closing PowerShell: TIMEOUT!");
                break;
            }
            Thread.sleep(10L);
            closingTime += 10;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PowerShellResponse executeSingleCommand(String command) {
        PowerShell session = null;
        PowerShellResponse response = null;
        try {
            try {
                session = PowerShell.openSession();
                response = session.executeCommand(command);
            }
            catch (PowerShellNotAvailableException ex) {
                Logger.getLogger(PowerShell.class.getName()).log(Level.SEVERE, "PowerShell not available", ex);
                Object var5_4 = null;
                if (session != null) {
                    session.close();
                }
            }
            Object var5_3 = null;
            if (session != null) {
                session.close();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (session != null) {
                session.close();
            }
            throw throwable;
        }
        return response;
    }
}

