/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.watcher;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.Editable;
import android.text.TextWatcher;
import androidx.annotation.NonNull;

public abstract class DynamicTextWatcher
implements TextWatcher {
    public static final int MESSAGE_TEXT_CHANGED = 1;
    public static final long DELAY_TEXT_CHANGE = 220L;
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1) {
                DynamicTextWatcher.this.delayedTextChanged((Editable)msg.obj);
            }
        }
    };

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.getHandler().removeMessages(1);
    }

    public void afterTextChanged(Editable s) {
        this.getHandler().sendMessageDelayed(this.getHandler().obtainMessage(1, (Object)s), this.getTextChangeDelay());
    }

    public abstract void delayedTextChanged(Editable var1);

    public long getTextChangeDelay() {
        return 220L;
    }

    @NonNull
    public Handler getHandler() {
        return this.mHandler;
    }
}

