/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.loader.handler;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;

public class TextViewHandler
extends Handler {
    private final WeakReference<TextView> mTextView;

    public TextViewHandler(@Nullable TextView textView) {
        super(Looper.getMainLooper());
        this.mTextView = new WeakReference<TextView>(textView);
    }

    public void handleMessage(@NonNull Message msg) {
        super.handleMessage(msg);
        if (this.getTextView() == null) {
            return;
        }
        if (msg.obj instanceof StringBuilder) {
            this.getTextView().setText((CharSequence)((StringBuilder)msg.obj), TextView.BufferType.SPANNABLE);
        } else if (msg.obj instanceof CharSequence) {
            this.getTextView().setText((CharSequence)msg.obj);
        } else {
            this.getTextView().setText(msg.what == 3 ? null : this.getTextView().getText());
        }
    }

    @Nullable
    public TextView getTextView() {
        if (this.mTextView == null) {
            return null;
        }
        return (TextView)this.mTextView.get();
    }
}

