/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.loader;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.pranavpandey.android.dynamic.util.DynamicPackageUtils;
import com.pranavpandey.android.dynamic.util.cache.DrawableLruCache;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicCallback;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicConcurrent;
import com.pranavpandey.android.dynamic.util.loader.handler.ImageViewHandler;
import com.pranavpandey.android.dynamic.util.loader.handler.TextViewHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class DynamicLoader {
    private static DynamicLoader sInstance;
    private static final Object sLock;
    private final DrawableLruCache<String> mDrawableLruCache = new DrawableLruCache();

    private DynamicLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static DynamicLoader getInstance() {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new DynamicLoader();
            }
        }
        return sInstance;
    }

    @Nullable
    public DrawableLruCache<String> getDrawableLruCache() {
        return this.mDrawableLruCache;
    }

    @Nullable
    private Drawable getDrawableFromCache(@Nullable String key) {
        if (this.getDrawableLruCache() == null || key == null) {
            return null;
        }
        return (Drawable)this.getDrawableLruCache().get(key);
    }

    private void putDrawableInCache(@Nullable String key, @Nullable Drawable drawable) {
        if (key != null && drawable != null && this.getDrawableLruCache() != null && this.getDrawableFromCache(key) == null) {
            this.getDrawableLruCache().put(key, drawable);
        }
    }

    public void clearDrawables() {
        try {
            if (this.getDrawableLruCache() != null) {
                this.getDrawableLruCache().evictAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public Drawable loadDrawable(@NonNull Context context, @DrawableRes int drawableRes) {
        Drawable drawable = this.getDrawableFromCache(String.valueOf(drawableRes));
        if (drawable == null) {
            drawable = ContextCompat.getDrawable((Context)context, (int)drawableRes);
        }
        this.putDrawableInCache(Integer.toString(drawableRes), drawable);
        return drawable;
    }

    @Nullable
    public Drawable loadAppIcon(@NonNull Context context, @Nullable String packageName) {
        Drawable icon = this.getDrawableFromCache(packageName);
        if (icon == null) {
            icon = DynamicPackageUtils.getAppIcon(context, packageName);
        }
        this.putDrawableInCache(packageName, icon);
        return icon;
    }

    @Nullable
    public <V, P, R> Future<?> setAsync(@Nullable ExecutorService executorService, @Nullable DynamicCallback<V, P, R> callback) {
        if (callback == null || callback.getView() == null) {
            return null;
        }
        if (callback.getView() instanceof ImageView) {
            return DynamicConcurrent.getInstance().async(executorService, new ImageViewHandler((ImageView)callback.getView()), callback);
        }
        if (callback.getView() instanceof TextView) {
            return DynamicConcurrent.getInstance().async(executorService, new TextViewHandler((TextView)callback.getView()), callback);
        }
        return null;
    }

    @Nullable
    public <V, P, R> Future<?> setAsync(@Nullable DynamicCallback<V, P, R> callback) {
        if (callback == null || callback.getView() == null) {
            return null;
        }
        if (callback.getView() instanceof ImageView) {
            return DynamicConcurrent.getInstance().async(new ImageViewHandler((ImageView)callback.getView()), callback);
        }
        if (callback.getView() instanceof TextView) {
            return DynamicConcurrent.getInstance().async(new TextViewHandler((TextView)callback.getView()), callback);
        }
        return null;
    }

    static {
        sLock = new Object();
    }
}

