/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.concurrent;

import androidx.annotation.NonNull;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public interface DynamicExecutor {
    public static final int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    public static final int CORE_POOL_SIZE = 1;
    public static final int MAXIMUM_POOL_SIZE = 20;
    public static final int BACKUP_POOL_SIZE = 10;
    public static final BlockingQueue<Runnable> WORK_QUEUE = new SynchronousQueue<Runnable>();
    public static final BlockingQueue<Runnable> BACKUP_WORK_QUEUE = new LinkedBlockingDeque<Runnable>();
    public static final long KEEP_ALIVE = 3000L;
    public static final TimeUnit KEEP_ALIVE_UNIT = TimeUnit.MILLISECONDS;
    public static final ThreadFactory THREAD_FACTORY = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "DynamicTask #" + this.mCount.getAndIncrement());
        }
    };

    @NonNull
    public ExecutorService getDefaultExecutor();
}

