/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util.concurrent;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicCallback;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicExecutor;
import com.pranavpandey.android.dynamic.util.concurrent.DynamicTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

public class DynamicConcurrent {
    public final ExecutorService SERIAL_EXECUTOR = Executors.newSingleThreadExecutor();
    public final ExecutorService THREAD_POOL_EXECUTOR = DynamicConcurrent.getDefaultExecutor();
    private static ThreadPoolExecutor sBackupExecutor;
    private static final RejectedExecutionHandler sRunOnSerialPolicy;
    private static DynamicConcurrent sInstance;
    private static final Object sLock;

    private DynamicConcurrent() {
        ((ThreadPoolExecutor)this.THREAD_POOL_EXECUTOR).setRejectedExecutionHandler(sRunOnSerialPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static DynamicConcurrent getInstance() {
        Object object = sLock;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new DynamicConcurrent();
            }
        }
        return sInstance;
    }

    @NonNull
    public static ExecutorService getDefaultExecutor() {
        return new ThreadPoolExecutor(1, 20, 3000L, DynamicExecutor.KEEP_ALIVE_UNIT, DynamicExecutor.WORK_QUEUE);
    }

    @NonNull
    public ExecutorService getSerialExecutor() {
        return this.SERIAL_EXECUTOR;
    }

    @NonNull
    public ExecutorService getThreadPoolExecutor() {
        return this.THREAD_POOL_EXECUTOR;
    }

    public void execute(@Nullable ExecutorService executorService, @Nullable Runnable runnable) {
        if (executorService == null || runnable == null) {
            return;
        }
        if (runnable instanceof DynamicTask) {
            ((DynamicTask)runnable).executeOnExecutor(executorService);
        } else {
            executorService.execute(runnable);
        }
    }

    public void execute(@Nullable Runnable runnable) {
        this.execute(this.getThreadPoolExecutor(), runnable);
    }

    @Nullable
    public <T, V> Future<?> submit(@Nullable ExecutorService executorService, @Nullable T task, @Nullable V result) {
        if (executorService != null && task != null) {
            if (task instanceof Runnable) {
                if (result != null) {
                    return executorService.submit((Runnable)task, result);
                }
                return executorService.submit((Runnable)task);
            }
            if (task instanceof Callable) {
                return executorService.submit((Callable)task);
            }
        }
        return null;
    }

    @Nullable
    public <T, V> Future<?> submit(@Nullable T task, @Nullable V result) {
        return this.submit(this.getThreadPoolExecutor(), task, result);
    }

    @Nullable
    public <T> Future<?> submit(@Nullable T task) {
        return this.submit(this.getThreadPoolExecutor(), task, null);
    }

    @Nullable
    public <V, P, R> Future<?> async(@Nullable ExecutorService executorService, final @Nullable Handler handler, final @Nullable DynamicCallback<V, P, R> callback) {
        if (handler == null || callback == null || callback.getView() == null) {
            return null;
        }
        Message message = Message.obtain();
        message.obj = callback.onPlaceholder(callback.getView());
        handler.sendMessage(message);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Message message = Message.obtain();
                message.obj = callback.onResult(callback.getView());
                handler.sendMessage(message);
            }
        };
        if (executorService != null) {
            return executorService.submit(runnable);
        }
        new Handler(Looper.getMainLooper()).post(runnable);
        return null;
    }

    @Nullable
    public <V, P, R> Future<?> async(@Nullable Handler handler, @Nullable DynamicCallback<V, P, R> callback) {
        return this.async(null, handler, callback);
    }

    static {
        sRunOnSerialPolicy = new RejectedExecutionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    if (sBackupExecutor == null) {
                        sBackupExecutor = new ThreadPoolExecutor(10, 10, 3000L, DynamicExecutor.KEEP_ALIVE_UNIT, DynamicExecutor.BACKUP_WORK_QUEUE, DynamicExecutor.THREAD_FACTORY);
                        sBackupExecutor.allowCoreThreadTimeOut(true);
                    }
                }
                sBackupExecutor.execute(r);
            }
        };
        sLock = new Object();
    }
}

