/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ShareCompat;
import androidx.core.content.FileProvider;
import com.pranavpandey.android.dynamic.util.DynamicSdkUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class DynamicFileUtils {
    public static final String FILE_MIME = "*/*";
    public static final String FILE_PROVIDER = ".FileProvider";
    public static final String URI_MATCHER_CONTENT = "content:";
    public static final String URI_MATCHER_FILE = "file:";
    public static final String ADU_DEFAULT_DIR_DATA = "data";
    public static final String ADU_DEFAULT_DIR_TEMP = "temp";
    public static final String ADU_MIME_OCTET_STREAM = "application/octet-stream";

    @Nullable
    public static String getTempDir(@NonNull Context context) {
        if (context.getExternalFilesDir(null) == null) {
            return null;
        }
        File temp = context.getExternalFilesDir(null);
        return temp != null ? temp.getPath() + File.separator + ADU_DEFAULT_DIR_DATA + File.separator + context.getPackageName() + File.separator + ADU_DEFAULT_DIR_TEMP + File.separator : null;
    }

    @Nullable
    public static File getDirectory(@NonNull String type) {
        return Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
    }

    @Nullable
    public static File getDirectory(@NonNull String type, @Nullable String fileName) {
        if (fileName == null) {
            return Environment.getExternalStoragePublicDirectory((String)type);
        }
        File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        if (file != null) {
            return new File(file.getPath() + File.separator + fileName);
        }
        return null;
    }

    @Nullable
    public static String getBaseName(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            return fileName;
        }
        return fileName.substring(0, index);
    }

    @Nullable
    public static String getExtension(@Nullable String fileName) {
        if (fileName == null) {
            return null;
        }
        String extension = null;
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            extension = fileName.substring(i + 1).toLowerCase(Locale.ROOT);
        }
        return extension;
    }

    @Nullable
    public static String getExtension(@Nullable File file) {
        if (file == null) {
            return null;
        }
        return DynamicFileUtils.getExtension(file.getName());
    }

    public static boolean verifyFile(@Nullable File file) {
        if (file == null) {
            return false;
        }
        boolean fileExists = file.exists();
        if (!fileExists) {
            fileExists = file.mkdirs();
        }
        return fileExists;
    }

    public static boolean deleteDirectory(@NonNull File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (String aChildren : children) {
                boolean success = DynamicFileUtils.deleteDirectory(new File(dir, aChildren));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void zipDirectory(@NonNull File dir, @NonNull File zip) throws IOException {
        if (zip.getParent() != null && DynamicFileUtils.verifyFile(new File(zip.getParent()))) {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zip));
            DynamicFileUtils.zip(dir, dir, zos);
            zos.close();
        }
    }

    private static void zip(@NonNull File dir, @NonNull File zip, @NonNull ZipOutputStream zos) throws IOException {
        File[] files = dir.listFiles();
        byte[] buffer = new byte[8192];
        if (files != null) {
            for (File file : files) {
                int read;
                if (file.isDirectory()) {
                    DynamicFileUtils.zip(file, zip, zos);
                    continue;
                }
                FileInputStream in = new FileInputStream(file);
                ZipEntry entry = new ZipEntry(file.getPath().substring(zip.getPath().length() + 1));
                zos.putNextEntry(entry);
                while (-1 != (read = in.read(buffer))) {
                    zos.write(buffer, 0, read);
                }
                in.close();
            }
        }
    }

    public static void unzip(@NonNull File zip, @NonNull File extractTo) throws SecurityException, IOException {
        ZipFile archive = new ZipFile(zip);
        Enumeration<? extends ZipEntry> entries = archive.entries();
        while (entries.hasMoreElements()) {
            int read;
            ZipEntry entry = entries.nextElement();
            File file = new File(extractTo, entry.getName());
            if (!file.getCanonicalPath().startsWith(extractTo.getCanonicalPath())) {
                throw new SecurityException("Unsafe unzipping pattern that may lead to a Path Traversal vulnerability.");
            }
            if (entry.isDirectory() && !file.exists()) {
                DynamicFileUtils.verifyFile(file);
                continue;
            }
            if (!DynamicFileUtils.verifyFile(file.getParentFile())) continue;
            InputStream in = archive.getInputStream(entry);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[8192];
            while (-1 != (read = in.read(buffer))) {
                out.write(buffer, 0, read);
            }
            in.close();
            out.close();
        }
    }

    @Nullable
    public static Uri getUriFromFile(@NonNull Context context, @Nullable File file) {
        if (file == null) {
            return null;
        }
        if (DynamicSdkUtils.is23()) {
            return FileProvider.getUriForFile((Context)context.getApplicationContext(), (String)(context.getPackageName() + FILE_PROVIDER), (File)file);
        }
        return Uri.fromFile((File)file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getFileNameFromUri(@NonNull Context context, @Nullable Uri uri) {
        if (uri == null) {
            return null;
        }
        String fileName = null;
        Cursor cursor = null;
        if (uri.toString().contains(URI_MATCHER_CONTENT)) {
            try {
                cursor = context.getContentResolver().query(uri, null, null, null, null);
                if (cursor == null) return fileName;
                int nameIndex = cursor.getColumnIndex("_display_name");
                cursor.moveToFirst();
                fileName = cursor.getString(nameIndex);
                return fileName;
            }
            catch (Exception exception) {
                return fileName;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        } else {
            if (!uri.toString().contains(URI_MATCHER_FILE)) return fileName;
            try {
                return new File(new URI(uri.toString())).getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToFile(@NonNull File source, @NonNull File destination, @NonNull String outputFileName) {
        boolean success;
        block8: {
            success = false;
            try {
                if (!DynamicFileUtils.verifyFile(destination)) break block8;
                FileInputStream input = new FileInputStream(source);
                FileOutputStream output = new FileOutputStream(destination + File.separator + outputFileName);
                try {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = input.read(buffer)) > 0) {
                        ((OutputStream)output).write(buffer, 0, length);
                    }
                    success = true;
                }
                catch (Exception exception) {
                }
                finally {
                    output.flush();
                    ((OutputStream)output).close();
                    input.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeToFile(@NonNull Context context, @Nullable Uri sourceUri, @Nullable Uri destinationUri, @NonNull String mode) {
        boolean success;
        block9: {
            if (sourceUri == null || destinationUri == null) {
                return false;
            }
            success = false;
            try {
                InputStream input = context.getContentResolver().openInputStream(sourceUri);
                ParcelFileDescriptor pfdDestination = context.getContentResolver().openFileDescriptor(destinationUri, mode);
                if (input == null || pfdDestination == null) break block9;
                FileOutputStream output = new FileOutputStream(pfdDestination.getFileDescriptor());
                try {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = input.read(buffer)) > 0) {
                        ((OutputStream)output).write(buffer, 0, length);
                    }
                    success = true;
                }
                catch (Exception exception) {
                }
                finally {
                    output.flush();
                    ((OutputStream)output).close();
                    input.close();
                    pfdDestination.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public static boolean writeToFile(@NonNull Context context, @Nullable Uri sourceUri, @Nullable Uri destinationUri) {
        return DynamicFileUtils.writeToFile(context, sourceUri, destinationUri, "rwt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeStringToFile(@NonNull Context context, @Nullable String data, @Nullable Uri sourceUri, @Nullable Uri destinationUri, @NonNull String mode) {
        if (sourceUri == null) {
            return false;
        }
        boolean success = false;
        try {
            ParcelFileDescriptor pfdDestination = context.getContentResolver().openFileDescriptor(sourceUri, mode);
            if (pfdDestination != null) {
                FileOutputStream output = new FileOutputStream(pfdDestination.getFileDescriptor());
                try {
                    if (data != null) {
                        ((OutputStream)output).write(data.getBytes());
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    output.flush();
                    ((OutputStream)output).close();
                    pfdDestination.close();
                }
            }
            success = destinationUri != null ? DynamicFileUtils.writeToFile(context, sourceUri, destinationUri) : true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return success;
    }

    public static boolean writeStringToFile(@NonNull Context context, @Nullable String data, @Nullable Uri sourceUri, @Nullable Uri destinationUri) {
        return DynamicFileUtils.writeStringToFile(context, data, sourceUri, destinationUri, "rwt");
    }

    public static boolean writeStringToFile(@NonNull Context context, @Nullable String data, @Nullable Uri sourceUri) {
        return DynamicFileUtils.writeStringToFile(context, data, sourceUri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String readStringFromFile(@NonNull Context context, @NonNull Uri fileUri) {
        String string2;
        block8: {
            string2 = null;
            try {
                InputStream input = context.getContentResolver().openInputStream(fileUri);
                if (input == null) break block8;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input));
                StringBuilder stringBuilder = new StringBuilder();
                try {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    input.close();
                    bufferedReader.close();
                }
                string2 = stringBuilder.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string2;
    }

    @Nullable
    public static Uri getBitmapUri(@NonNull Context context, @Nullable Bitmap bitmap, @NonNull String name, @Nullable String extension) {
        Uri bitmapUri = null;
        if (extension == null) {
            extension = ".png";
        }
        if (bitmap != null) {
            try {
                File picturesDir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
                if (picturesDir != null) {
                    File storagePath = new File(picturesDir.getPath(), name);
                    String image = storagePath + File.separator + name + extension;
                    storagePath.mkdirs();
                    FileOutputStream out = new FileOutputStream(image);
                    bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
                    out.close();
                    bitmapUri = DynamicFileUtils.getUriFromFile(context, new File(image));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bitmapUri;
    }

    @Nullable
    public static Uri getBitmapUri(@NonNull Context context, @Nullable Bitmap bitmap, @NonNull String name) {
        return DynamicFileUtils.getBitmapUri(context, bitmap, name, null);
    }

    public static boolean isValidExtension(@Nullable String path, @Nullable String extension) {
        if (path == null || extension == null) {
            return false;
        }
        return extension.equals("." + DynamicFileUtils.getExtension(path));
    }

    public static boolean isValidExtension(@Nullable Context context, @Nullable File file, @Nullable String extension) {
        if (context == null || file == null || extension == null) {
            return false;
        }
        return DynamicFileUtils.isValidExtension(file.getName(), extension);
    }

    public static boolean isValidExtension(@Nullable Context context, @Nullable Uri uri, @Nullable String extension) {
        if (context == null || uri == null || extension == null) {
            return false;
        }
        return DynamicFileUtils.isValidExtension(DynamicFileUtils.getFileNameFromUri(context, uri), extension);
    }

    public static boolean isValidExtension(@Nullable Context context, @Nullable Intent intent, @Nullable String extension) {
        if (context == null || intent == null || extension == null) {
            return false;
        }
        return DynamicFileUtils.isValidExtension(context, "android.intent.action.SEND".equals(intent.getAction()) ? (Uri)intent.getParcelableExtra("android.intent.extra.STREAM") : intent.getData(), extension);
    }

    public static boolean isValidMimeType(@Nullable Context context, @Nullable Intent intent, @NonNull String mimeType, @Nullable String extension) {
        if (intent == null || intent.getAction() == null) {
            return false;
        }
        boolean validMime = mimeType.equals(intent.getType());
        if (!validMime) {
            validMime = intent.getParcelableExtra("android.intent.extra.STREAM") != null ? DynamicFileUtils.isValidMimeType(context, (Uri)intent.getParcelableExtra("android.intent.extra.STREAM"), ADU_MIME_OCTET_STREAM, extension) && DynamicFileUtils.isValidExtension(context, (Uri)intent.getParcelableExtra("android.intent.extra.STREAM"), extension) : DynamicFileUtils.isValidMimeType(context, intent.getData(), ADU_MIME_OCTET_STREAM, extension) && DynamicFileUtils.isValidExtension(context, intent.getData(), extension);
        }
        return validMime;
    }

    public static boolean isValidMimeType(@Nullable Context context, @Nullable Uri uri, @NonNull String mimeType, @Nullable String extension) {
        boolean validMime;
        if (context == null || uri == null) {
            return false;
        }
        String type = context.getApplicationContext().getContentResolver().getType(uri);
        boolean bl = validMime = type != null && type.contains(mimeType);
        if (!validMime) {
            validMime = (type == null || ADU_MIME_OCTET_STREAM.equals(type)) && DynamicFileUtils.isValidExtension(context, uri, extension);
        }
        return validMime;
    }

    public static boolean isValidMimeType(@NonNull Context context, @Nullable File file, @NonNull String mimeType, @Nullable String extension) {
        return DynamicFileUtils.isValidMimeType(context, DynamicFileUtils.getUriFromFile(context, file), mimeType, extension);
    }

    public static void shareFile(@NonNull Activity activity, @Nullable String title, @Nullable String subject, @NonNull File file, @NonNull String mimeType) {
        Intent shareBackup = new ShareCompat.IntentBuilder((Context)activity).setType(mimeType).setSubject(subject != null ? subject : title).setStream(DynamicFileUtils.getUriFromFile((Context)activity, file)).setChooserTitle((CharSequence)title).createChooserIntent().addFlags(3);
        activity.startActivity(shareBackup);
    }

    public static void shareFiles(@NonNull Activity activity, @Nullable String title, @Nullable String subject, @NonNull Uri[] uris, @Nullable String mimeType) {
        ShareCompat.IntentBuilder intentBuilder = new ShareCompat.IntentBuilder((Context)activity).setSubject(subject != null ? subject : title).setType(mimeType != null ? mimeType : FILE_MIME).setChooserTitle((CharSequence)title);
        for (Uri uri : uris) {
            intentBuilder.addStream(uri);
        }
        Intent shareBackup = intentBuilder.createChooserIntent().addFlags(3);
        activity.startActivity(shareBackup);
    }

    @TargetApi(value=19)
    @NonNull
    public static Intent getSaveToFileIntent(@NonNull Context context, @Nullable Uri file, @NonNull String mimeType) {
        Intent intent = DynamicSdkUtils.is19() ? new Intent("android.intent.action.CREATE_DOCUMENT") : new Intent("android.intent.action.PICK");
        intent.addFlags(0x800003);
        intent.addCategory("android.intent.category.OPENABLE");
        intent.putExtra("android.intent.extra.TITLE", DynamicFileUtils.getFileNameFromUri(context, file));
        intent.putExtra("android.intent.extra.STREAM", (Parcelable)file);
        intent.setType(mimeType);
        return intent;
    }

    @NonNull
    public static Intent getSaveToFileIntent(@NonNull Context context, @Nullable File file, @NonNull String mimeType) {
        return DynamicFileUtils.getSaveToFileIntent(context, DynamicFileUtils.getUriFromFile(context, file), mimeType);
    }

    @TargetApi(value=19)
    @NonNull
    public static Intent getFileSelectIntent(@NonNull String mimeType) {
        Intent intent;
        if (DynamicSdkUtils.is19()) {
            intent = new Intent("android.intent.action.OPEN_DOCUMENT");
            intent.setType(FILE_MIME);
        } else {
            intent = new Intent("android.intent.action.GET_CONTENT");
            intent.setType(mimeType);
        }
        intent.addCategory("android.intent.category.OPENABLE");
        intent.addFlags(0x800001);
        return intent;
    }
}

