/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.annotation.TargetApi;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import com.pranavpandey.android.dynamic.util.DynamicSdkUtils;
import com.pranavpandey.android.dynamic.util.DynamicUnitUtils;

public class DynamicDrawableUtils {
    @TargetApi(value=16)
    public static void setBackground(@NonNull View view, @Nullable Drawable drawable) {
        if (DynamicSdkUtils.is16()) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    @Nullable
    public static Drawable colorizeDrawable(@Nullable Drawable drawable, boolean wrap, @NonNull ColorFilter colorFilter) {
        if (drawable != null) {
            if (wrap) {
                drawable = drawable.mutate();
            }
            drawable.setColorFilter(colorFilter);
            drawable.invalidateSelf();
        }
        return drawable;
    }

    @Nullable
    public static Drawable colorizeDrawable(@Nullable Drawable drawable, boolean wrap, @ColorInt int color, @Nullable PorterDuff.Mode mode) {
        if (drawable != null) {
            if (mode == null) {
                mode = PorterDuff.Mode.SRC_IN;
            }
            if (wrap) {
                try {
                    drawable = DrawableCompat.wrap((Drawable)drawable);
                    drawable = drawable.mutate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            DrawableCompat.setTintMode((Drawable)drawable, (PorterDuff.Mode)mode);
            DrawableCompat.setTint((Drawable)drawable, (int)color);
            drawable.invalidateSelf();
        }
        return drawable;
    }

    @Nullable
    public static Drawable colorizeDrawable(@Nullable Drawable drawable, @ColorInt int color, @Nullable PorterDuff.Mode mode) {
        return DynamicDrawableUtils.colorizeDrawable(drawable, true, color, mode);
    }

    @Nullable
    public static Drawable colorizeDrawable(@Nullable Drawable drawable, boolean wrap, @ColorInt int color) {
        return DynamicDrawableUtils.colorizeDrawable(drawable, wrap, color, PorterDuff.Mode.SRC_IN);
    }

    @Nullable
    public static Drawable colorizeDrawable(@Nullable Drawable drawable, @ColorInt int color) {
        return DynamicDrawableUtils.colorizeDrawable(drawable, true, color);
    }

    @Nullable
    public static Drawable colorizeDrawable(@Nullable Drawable drawable, @NonNull ColorFilter colorFilter) {
        return DynamicDrawableUtils.colorizeDrawable(drawable, true, colorFilter);
    }

    @NonNull
    public static Drawable getCornerDrawable(int width, int height, @NonNull GradientDrawable drawable, @ColorInt int color) {
        drawable.setColor(color);
        if (width > 0 && height > 0) {
            drawable.setSize(DynamicUnitUtils.convertDpToPixels(width), DynamicUnitUtils.convertDpToPixels(height));
        }
        return drawable;
    }

    @NonNull
    public static Drawable getCornerDrawable(int width, int height, @NonNull GradientDrawable drawable) {
        return DynamicDrawableUtils.getCornerDrawable(width, height, drawable, -1);
    }

    @NonNull
    public static Drawable getCornerDrawable(@NonNull GradientDrawable drawable, @ColorInt int color) {
        return DynamicDrawableUtils.getCornerDrawable(0, 0, drawable, color);
    }

    @NonNull
    public static Drawable getCornerDrawable(@NonNull GradientDrawable drawable) {
        return DynamicDrawableUtils.getCornerDrawable(0, 0, drawable, -1);
    }

    @NonNull
    public static Drawable getCornerDrawable(int width, int height, float cornerRadius, @ColorInt int color) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setCornerRadius((float)DynamicUnitUtils.convertDpToPixels(cornerRadius));
        return DynamicDrawableUtils.getCornerDrawable(width, height, drawable, color);
    }

    @NonNull
    public static Drawable getCornerDrawable(int width, int height, float cornerRadius) {
        return DynamicDrawableUtils.getCornerDrawable(width, height, cornerRadius, -1);
    }

    @NonNull
    public static Drawable getCornerDrawable(float cornerRadius, @ColorInt int color) {
        return DynamicDrawableUtils.getCornerDrawable(0, 0, cornerRadius, color);
    }

    @NonNull
    public static Drawable getCornerDrawable(float cornerRadius) {
        return DynamicDrawableUtils.getCornerDrawable(0, 0, cornerRadius, -1);
    }
}

