/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.text.format.DateFormat;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.core.content.ContextCompat;
import com.pranavpandey.android.dynamic.util.DynamicIntentUtils;
import com.pranavpandey.android.dynamic.util.DynamicSdkUtils;
import com.pranavpandey.android.dynamic.util.R;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class DynamicDeviceUtils {
    @RequiresPermission(value="android.permission.VIBRATE")
    @TargetApi(value=26)
    public static void vibrate(@Nullable Context context, long duration) {
        if (context == null) {
            return;
        }
        Vibrator vibrator = (Vibrator)ContextCompat.getSystemService((Context)context, Vibrator.class);
        if (vibrator == null) {
            return;
        }
        if (DynamicSdkUtils.is26()) {
            vibrator.vibrate(VibrationEffect.createOneShot((long)duration, (int)-1));
        } else {
            vibrator.vibrate(duration);
        }
    }

    public static boolean hasTelephony(@NonNull Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @NonNull
    public static String getDate(@NonNull Context context, long milliSeconds) {
        java.text.DateFormat df = DateFormat.getDateFormat((Context)context);
        java.text.DateFormat tf = DateFormat.getTimeFormat((Context)context);
        return String.format(context.getResources().getString(R.string.adu_format_blank_space), df.format(milliSeconds), tf.format(milliSeconds));
    }

    @NonNull
    public static String getDateWithSeparator(long milliSeconds) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss", Locale.getDefault());
        return dateFormat.format(milliSeconds);
    }

    public static boolean isXiaomiMIUI(@NonNull Context context) {
        return DynamicIntentUtils.isActivityResolved(context, new Intent("miui.intent.action.OP_AUTO_START").addCategory("android.intent.category.DEFAULT")) || DynamicIntentUtils.isActivityResolved(context, new Intent().setComponent(new ComponentName("com.miui.securitycenter", "com.miui.permcenter.autostart.AutoStartManagementActivity"))) || DynamicIntentUtils.isActivityResolved(context, new Intent("miui.intent.action.POWER_HIDE_MODE_APP_LIST").addCategory("android.intent.category.DEFAULT")) || DynamicIntentUtils.isActivityResolved(context, new Intent().setComponent(new ComponentName("com.miui.securitycenter", "com.miui.powercenter.PowerSettings")));
    }
}

