/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.util;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.core.graphics.ColorUtils;
import com.pranavpandey.android.dynamic.util.cache.IntegerLruCache;
import java.util.Random;

public class DynamicColorUtils {
    private static final float VISIBLE_CONTRAST = 0.45f;
    private static final float MAX_CONTRAST = 1.0f;
    private static final float CONTRAST_FACTOR = 1.5f;
    private static final IntegerLruCache<String> mColorLruCache = new IntegerLruCache();

    @ColorInt
    public static int getRandomColor() {
        Random random = new Random();
        float hue = random.nextInt(360);
        float saturation = random.nextFloat();
        float lightness = random.nextFloat();
        return ColorUtils.HSLToColor((float[])new float[]{hue, saturation, lightness});
    }

    @ColorInt
    public static int getRandomColor(@ColorInt int color) {
        int newColor = DynamicColorUtils.getRandomColor();
        if (newColor != color) {
            return newColor;
        }
        return DynamicColorUtils.getRandomColor();
    }

    @ColorInt
    public static int adjustAlpha(@ColorInt int color, float factor) {
        int alpha = Math.min(255, (int)((float)Color.alpha((int)color) * factor));
        int red = Color.red((int)color);
        int green = Color.green((int)color);
        int blue = Color.blue((int)color);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public static boolean isAlpha(@ColorInt int color) {
        return Color.alpha((int)color) != 255;
    }

    @ColorInt
    public static int setAlpha(@ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        return Color.argb((int)alpha, (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    @ColorInt
    public static int removeAlpha(@ColorInt int color) {
        return Color.rgb((int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
    }

    public static boolean isTranslucent(@ColorInt int color) {
        return Color.alpha((int)color) > 0 && Color.alpha((int)color) < 255;
    }

    public static double getColorDarkness(@ColorInt int color) {
        return 1.0 - (0.299 * (double)Color.red((int)color) + 0.587 * (double)Color.green((int)color) + 0.114 * (double)Color.blue((int)color)) / 255.0;
    }

    public static boolean isColorDark(@ColorInt int color) {
        return DynamicColorUtils.getColorDarkness(color) >= 0.5;
    }

    private static float calculateXyzLuma(@ColorInt int color) {
        return (0.2126f * (float)Color.red((int)color) + 0.7152f * (float)Color.green((int)color) + 0.0722f * (float)Color.blue((int)color)) / 255.0f;
    }

    @ColorInt
    public static int getDarkerColor(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float amount, boolean adjust) {
        if (adjust) {
            float[] hsv = new float[3];
            Color.colorToHSV((int)color, (float[])hsv);
            if (hsv[2] == 1.0f) {
                hsv[2] = Math.max(0.0f, Math.min(amount, 0.45f));
                color = Color.HSVToColor((int)Color.alpha((int)color), (float[])hsv);
            }
        }
        int alpha = (int)((float)Color.alpha((int)color) * (1.0f - amount));
        int red = (int)((float)Color.red((int)color) * (1.0f - amount));
        int green = (int)((float)Color.green((int)color) * (1.0f - amount));
        int blue = (int)((float)Color.blue((int)color) * (1.0f - amount));
        return Color.argb((int)Math.max(alpha, Color.alpha((int)color)), (int)red, (int)green, (int)blue);
    }

    @ColorInt
    public static int getDarkerColor(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float amount) {
        return DynamicColorUtils.getDarkerColor(color, amount, true);
    }

    @ColorInt
    public static int getLighterColor(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float amount, boolean adjust) {
        if (adjust) {
            float[] hsv = new float[3];
            Color.colorToHSV((int)color, (float[])hsv);
            if (hsv[2] == 0.0f) {
                hsv[2] = Math.min(1.0f, Math.max(amount, 0.45f));
                color = Color.HSVToColor((int)Color.alpha((int)color), (float[])hsv);
            }
        }
        int alpha = (int)((float)Color.alpha((int)color) + (float)(255 - Color.alpha((int)color)) * amount);
        int red = (int)((float)Color.red((int)color) + (float)(255 - Color.red((int)color)) * amount);
        int green = (int)((float)Color.green((int)color) + (float)(255 - Color.green((int)color)) * amount);
        int blue = (int)((float)Color.blue((int)color) + (float)(255 - Color.blue((int)color)) * amount);
        return Color.argb((int)Math.max(alpha, Color.alpha((int)color)), (int)red, (int)green, (int)blue);
    }

    @ColorInt
    public static int getLighterColor(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float amount) {
        return DynamicColorUtils.getLighterColor(color, amount, true);
    }

    @ColorInt
    public static int shiftColor(@ColorInt int color, @FloatRange(from=0.0, to=2.0) float by) {
        if (by == 1.0f) {
            return color;
        }
        int alpha = Color.alpha((int)color);
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[2] = hsv[2] * by;
        return Color.HSVToColor((int)alpha, (float[])hsv);
    }

    @ColorInt
    public static int shiftColor(@ColorInt int color, @FloatRange(from=0.0, to=2.0) float shiftLightBy, @FloatRange(from=0.0, to=2.0) float shiftDarkBy) {
        return DynamicColorUtils.shiftColor(color, DynamicColorUtils.isColorDark(color) ? shiftDarkBy : shiftLightBy);
    }

    @ColorInt
    public static int getAccentColor(@ColorInt int color) {
        int a = Color.alpha((int)color);
        int r = Color.red((int)color);
        int g = Color.green((int)color);
        int b = Color.blue((int)color);
        double Y = (double)(r * 299 + g * 587 + b * 114) / 1000.0;
        int rc = b ^ 0x55;
        int gc = g & 0xFA;
        int bc = r ^ 0x55;
        int finalColor = Color.argb((int)a, (int)rc, (int)gc, (int)bc);
        int r1 = Color.red((int)finalColor);
        int g1 = Color.green((int)finalColor);
        int b1 = Color.blue((int)finalColor);
        double YC = (double)(r1 * 299 + g1 * 587 + b1 * 114) / 1000.0;
        int CD = Math.max(r, r1) - Math.min(r, r1) + (Math.max(g, g1) - Math.min(g, g1)) + (Math.max(b, b1) - Math.min(b, b1));
        if (Y - YC <= 50.0 && CD <= 200) {
            rc = b ^ 0xFA;
            gc = g & 0x55;
            bc = r ^ 0x55;
        }
        finalColor = Color.argb((int)a, (int)rc, (int)gc, (int)bc);
        return finalColor;
    }

    public static float calculateContrast(@ColorInt int color1, @ColorInt int color2) {
        float luminance = 0.0f;
        float luminance1 = DynamicColorUtils.calculateXyzLuma(color1);
        float luminance2 = DynamicColorUtils.calculateXyzLuma(color2);
        boolean color1Dark = DynamicColorUtils.isColorDark(color1);
        boolean color2Dark = DynamicColorUtils.isColorDark(color2);
        if (DynamicColorUtils.removeAlpha(color1) != DynamicColorUtils.removeAlpha(color2) && color1Dark == color2Dark) {
            if (DynamicColorUtils.isAlpha(color1)) {
                luminance += 0.2126f * (float)Color.alpha((int)color1) / 255.0f;
            }
            if (DynamicColorUtils.isAlpha(color2)) {
                luminance += 0.2126f * (float)Color.alpha((int)color2) / 255.0f;
            }
        }
        return Math.abs(Math.max(luminance1, luminance2) - Math.min(luminance1, luminance2) - luminance);
    }

    @ColorInt
    public static int getTintColor(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float visibleContrast) {
        return DynamicColorUtils.getContrastColor(color, color, visibleContrast);
    }

    @ColorInt
    public static int getTintColor(@ColorInt int color) {
        return DynamicColorUtils.getContrastColor(color, color);
    }

    @ColorInt
    public static int getStateColor(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float lightenBy, @FloatRange(from=0.0, to=1.0) float darkenBy) {
        return DynamicColorUtils.isColorDark(color) ? DynamicColorUtils.getLighterColor(color, lightenBy) : DynamicColorUtils.getDarkerColor(color, darkenBy);
    }

    @ColorInt
    public static int getContrastColor(@ColorInt int color, @ColorInt int contrastWith, @FloatRange(from=0.0, to=1.0) float visibleContrast, boolean recursive) {
        String key = Integer.toString(color) + contrastWith + visibleContrast;
        Integer contrastColor = (Integer)mColorLruCache.get(key);
        if (contrastColor != null) {
            return contrastColor;
        }
        float contrast = DynamicColorUtils.calculateContrast(color, contrastWith);
        if (contrast < visibleContrast) {
            float finalContrast = Math.min(1.0f, Math.max(visibleContrast, (visibleContrast - contrast) * 1.5f));
            contrastColor = DynamicColorUtils.isColorDark(contrastWith) ? Integer.valueOf(recursive && DynamicColorUtils.isColorDark(color) ? DynamicColorUtils.getContrastColor(color, color, visibleContrast, false) : DynamicColorUtils.getLighterColor(color, finalContrast)) : Integer.valueOf(recursive && !DynamicColorUtils.isColorDark(color) ? DynamicColorUtils.getContrastColor(color, color, visibleContrast, false) : DynamicColorUtils.getDarkerColor(color, finalContrast));
            mColorLruCache.put(key, contrastColor);
            return contrastColor;
        }
        return color;
    }

    @ColorInt
    public static int getContrastColor(@ColorInt int color, @ColorInt int contrastWith, @FloatRange(from=0.0, to=1.0) float visibleContrast) {
        return DynamicColorUtils.getContrastColor(color, contrastWith, visibleContrast, true);
    }

    @ColorInt
    public static int getContrastColor(@ColorInt int color, @ColorInt int contrastWith) {
        return DynamicColorUtils.getContrastColor(color, contrastWith, 0.45f);
    }

    @ColorInt
    public static int getLessVisibleColor(@ColorInt int color) {
        return DynamicColorUtils.shiftColor(color, DynamicColorUtils.isColorDark(color) ? 0.6f : 1.6f);
    }

    public static String getColorString(@ColorInt int color, boolean includeAlpha, boolean includeHash) {
        String colorString = includeAlpha ? String.format("%08X", color) : String.format("%06X", 0xFFFFFF & color);
        if (includeHash) {
            colorString = "#" + colorString;
        }
        return colorString;
    }

    @ColorInt
    public static int CMYKToRGB(@FloatRange(from=0.0, to=100.0) float cyan, @FloatRange(from=0.0, to=100.0) float magenta, @FloatRange(from=0.0, to=100.0) float yellow, @FloatRange(from=0.0, to=100.0) float black) {
        float red = 255.0f * (1.0f - cyan / 100.0f) * (1.0f - black / 100.0f);
        float green = 255.0f * (1.0f - magenta / 100.0f) * (1.0f - black / 100.0f);
        float blue = 255.0f * (1.0f - yellow / 100.0f) * (1.0f - black / 100.0f);
        return Color.rgb((int)Math.round(red), (int)Math.round(green), (int)Math.round(blue));
    }

    public static void colorToCMYK(@ColorInt int color, @NonNull @Size(value=4L) float[] cmyk) {
        float red = (float)Color.red((int)color) / 255.0f;
        float green = (float)Color.green((int)color) / 255.0f;
        float blue = (float)Color.blue((int)color) / 255.0f;
        cmyk[3] = 1.0f - Math.max(Math.max(red, green), blue);
        cmyk[0] = (1.0f - red - cmyk[3]) / (1.0f - cmyk[3]);
        cmyk[1] = (1.0f - green - cmyk[3]) / (1.0f - cmyk[3]);
        cmyk[2] = (1.0f - blue - cmyk[3]) / (1.0f - cmyk[3]);
    }
}

