/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.toasts.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.pranavpandey.android.dynamic.toasts.internal.ToastContext;
import com.pranavpandey.android.dynamic.util.DynamicSdkUtils;
import java.lang.reflect.Field;

public final class ToastCompat
extends Toast {
    @NonNull
    private final Toast mToast;

    public ToastCompat(Context context, @NonNull Toast base) {
        super(context);
        this.mToast = base;
    }

    @SuppressLint(value={"ShowToast"})
    public static ToastCompat makeText(@NonNull Context context, @Nullable CharSequence text, int duration) {
        Toast toast = Toast.makeText((Context)context, (CharSequence)text, (int)duration);
        ToastCompat.setToastContext(toast.getView(), (Context)new ToastContext(context, toast));
        return new ToastCompat(context, toast);
    }

    public static Toast makeText(@NonNull Context context, @StringRes int resId, int duration) throws Resources.NotFoundException {
        return ToastCompat.makeText(context, context.getResources().getText(resId), duration);
    }

    @SuppressLint(value={"DiscouragedPrivateApi"})
    private static void setToastContext(@Nullable View view, @NonNull Context context) {
        if (view != null && DynamicSdkUtils.is25()) {
            try {
                Field field = View.class.getDeclaredField("mContext");
                field.setAccessible(true);
                field.set(view, context);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void show() {
        this.mToast.show();
    }

    public void setDuration(int duration) {
        this.mToast.setDuration(duration);
    }

    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.mToast.setGravity(gravity, xOffset, yOffset);
    }

    public void setMargin(float horizontalMargin, float verticalMargin) {
        this.mToast.setMargin(horizontalMargin, verticalMargin);
    }

    public void setText(int resId) {
        this.mToast.setText(resId);
    }

    public void setText(CharSequence s) {
        this.mToast.setText(s);
    }

    public void setView(View view) {
        this.mToast.setView(view);
        ToastCompat.setToastContext(view, (Context)new ToastContext(view.getContext(), this));
    }

    public float getHorizontalMargin() {
        return this.mToast.getHorizontalMargin();
    }

    public float getVerticalMargin() {
        return this.mToast.getVerticalMargin();
    }

    public int getDuration() {
        return this.mToast.getDuration();
    }

    public int getGravity() {
        return this.mToast.getGravity();
    }

    public int getXOffset() {
        return this.mToast.getXOffset();
    }

    public int getYOffset() {
        return this.mToast.getYOffset();
    }

    @Nullable
    public View getView() {
        return this.mToast.getView();
    }

    @NonNull
    public Toast getToast() {
        return this.mToast;
    }
}

