/*
 * Decompiled with CFR 0.152.
 */
package com.pranavpandey.android.dynamic.toasts;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.pranavpandey.android.dynamic.toasts.R;
import com.pranavpandey.android.dynamic.toasts.internal.ToastCompat;
import com.pranavpandey.android.dynamic.util.DynamicColorUtils;
import com.pranavpandey.android.dynamic.util.DynamicDrawableUtils;
import com.pranavpandey.android.dynamic.util.DynamicUnitUtils;

public class DynamicHint {
    private static final int ADT_INSET_TOP = 32;
    private static final int ADT_MIN_ANCHOR_HEIGHT = 48;
    private static final int ADT_TOAST_OFFSET = 4;
    @ColorInt
    private static final int ADT_DEFAULT_BG_COLOR = Color.parseColor((String)"#454545");
    @ColorInt
    private static final int ADT_DEFAULT_TINT_COLOR = Color.parseColor((String)"#FFFFFF");
    @ColorInt
    private static final int ADT_DEFAULT_ERROR_BG_COLOR = Color.parseColor((String)"#F44336");
    @ColorInt
    private static final int ADT_DEFAULT_SUCCESS_BG_COLOR = Color.parseColor((String)"#4CAF50");
    @ColorInt
    private static final int ADT_DEFAULT_WARNING_BG_COLOR = Color.parseColor((String)"#FFEB3B");
    private static final boolean ADT_DEFAULT_DISABLE_ICON = false;
    private static final boolean ADT_DEFAULT_TINT_ICON = true;
    @ColorInt
    private static final int ADT_DEFAULT_ICON_SIZE = -1;
    @ColorInt
    private static final int ADT_DEFAULT_TEXT_SIZE = -1;
    @Nullable
    @ColorInt
    private static Integer defaultBackgroundColor = ADT_DEFAULT_BG_COLOR;
    @Nullable
    @ColorInt
    private static Integer defaultTintColor = ADT_DEFAULT_TINT_COLOR;
    @Nullable
    @ColorInt
    private static Integer errorBackgroundColor = ADT_DEFAULT_ERROR_BG_COLOR;
    @Nullable
    @ColorInt
    private static Integer successBackgroundColor = ADT_DEFAULT_SUCCESS_BG_COLOR;
    @Nullable
    @ColorInt
    private static Integer warningBackgroundColor = ADT_DEFAULT_WARNING_BG_COLOR;
    private static Drawable errorIcon = null;
    private static Drawable successIcon = null;
    private static Drawable warningIcon = null;
    private static boolean disableIcon = false;
    private static boolean tintIcon = true;
    private static int iconSize = -1;
    private static int textSize = -1;
    private static Typeface textTypeface = null;
    private static Drawable toastBackground = null;

    @Nullable
    @ColorInt
    private static Integer generateTintColor(@Nullable @ColorInt Integer color, @Nullable @ColorInt Integer defaultColor) {
        if (color != null) {
            return DynamicColorUtils.getTintColor((int)color);
        }
        return defaultColor;
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text) {
        return DynamicHint.make(context, text, null, defaultTintColor, defaultBackgroundColor, 0);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, int duration) {
        return DynamicHint.make(context, text, null, defaultTintColor, defaultBackgroundColor, duration);
    }

    @NonNull
    public static Toast makeError(@NonNull Context context, @Nullable CharSequence text) {
        return DynamicHint.make(context, text, errorIcon != null ? errorIcon : ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_error), DynamicHint.generateTintColor(errorBackgroundColor, defaultTintColor), errorBackgroundColor);
    }

    @NonNull
    public static Toast makeError(@NonNull Context context, @Nullable CharSequence text, int duration) {
        return DynamicHint.make(context, text, ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_error), DynamicHint.generateTintColor(errorBackgroundColor, defaultTintColor), errorBackgroundColor, duration);
    }

    @NonNull
    public static Toast makeSuccess(@NonNull Context context, @Nullable CharSequence text) {
        return DynamicHint.make(context, text, successIcon != null ? successIcon : ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_success), DynamicHint.generateTintColor(successBackgroundColor, defaultTintColor), successBackgroundColor);
    }

    @NonNull
    public static Toast makeSuccess(@NonNull Context context, @Nullable CharSequence text, int duration) {
        return DynamicHint.make(context, text, ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_success), DynamicHint.generateTintColor(successBackgroundColor, defaultTintColor), successBackgroundColor, duration);
    }

    @NonNull
    public static Toast makeWarning(@NonNull Context context, @Nullable CharSequence text) {
        return DynamicHint.make(context, text, warningIcon != null ? warningIcon : ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_warning), DynamicHint.generateTintColor(warningBackgroundColor, defaultTintColor), warningBackgroundColor);
    }

    @NonNull
    public static Toast makeWarning(@NonNull Context context, @Nullable CharSequence text, int duration) {
        return DynamicHint.make(context, text, ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_ic_warning), DynamicHint.generateTintColor(warningBackgroundColor, defaultTintColor), warningBackgroundColor, duration);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable Drawable icon) {
        return DynamicHint.make(context, text, icon, defaultTintColor, defaultBackgroundColor, 0);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable Drawable icon, int duration) {
        return DynamicHint.make(context, text, icon, defaultTintColor, defaultBackgroundColor, duration);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable @ColorInt Integer tintColor, @Nullable @ColorInt Integer backgroundColor) {
        return DynamicHint.make(context, text, null, tintColor, backgroundColor, 0);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable @ColorInt Integer tintColor, @Nullable @ColorInt Integer backgroundColor, int duration) {
        return DynamicHint.make(context, text, null, tintColor, backgroundColor, duration);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable Drawable icon, @Nullable @ColorInt Integer tintColor, @Nullable @ColorInt Integer backgroundColor) {
        return DynamicHint.make(context, text, icon, tintColor, backgroundColor, 0);
    }

    @NonNull
    public static Toast make(@NonNull Context context, @Nullable CharSequence text, @Nullable Drawable icon, @Nullable @ColorInt Integer tintColor, @Nullable @ColorInt Integer backgroundColor, int duration) {
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            context = context.getApplicationContext();
        }
        Integer toastTintColor = tintColor;
        if (tintColor != null && backgroundColor != null) {
            toastTintColor = DynamicColorUtils.getContrastColor((int)toastTintColor, (int)backgroundColor);
        }
        ToastCompat toast = new ToastCompat(context, new Toast(context));
        View toastLayout = LayoutInflater.from((Context)context).inflate(R.layout.adt_layout_hint, (ViewGroup)new LinearLayout(context), false);
        ImageView toastIcon = (ImageView)toastLayout.findViewById(R.id.adt_hint_icon);
        TextView toastText = (TextView)toastLayout.findViewById(R.id.adt_hint_text);
        if (!disableIcon && icon != null) {
            if (iconSize != -1) {
                toastIcon.getLayoutParams().width = iconSize;
                toastIcon.getLayoutParams().height = iconSize;
                toastIcon.requestLayout();
            }
            if (tintIcon && toastTintColor != null) {
                toastIcon.setColorFilter(toastTintColor.intValue());
            } else {
                toastIcon.clearColorFilter();
            }
            toastIcon.setImageDrawable(icon);
        } else {
            toastIcon.setVisibility(8);
        }
        if (textTypeface != null) {
            toastText.setTypeface(textTypeface);
        }
        if (textSize != -1) {
            toastText.setTextSize(2, (float)textSize);
        }
        if (toastTintColor != null) {
            toastText.setTextColor(toastTintColor.intValue());
        }
        toastText.setText(text);
        if (toastBackground != null) {
            DynamicDrawableUtils.setBackground((View)toastLayout, (Drawable)(backgroundColor != null ? DynamicDrawableUtils.colorizeDrawable((Drawable)toastBackground, (int)backgroundColor, (PorterDuff.Mode)PorterDuff.Mode.MULTIPLY) : toastBackground));
        } else {
            DynamicDrawableUtils.setBackground((View)toastLayout, (Drawable)(backgroundColor != null ? DynamicDrawableUtils.colorizeDrawable((Drawable)ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_hint_background), (int)backgroundColor, (PorterDuff.Mode)PorterDuff.Mode.MULTIPLY) : ContextCompat.getDrawable((Context)context, (int)R.drawable.adt_hint_background)));
        }
        toast.setDuration(duration);
        toast.setView(toastLayout);
        return toast;
    }

    public static void show(@NonNull View anchor, @NonNull Toast toast) {
        DynamicHint.show(anchor, toast, 4);
    }

    public static void show(@NonNull View anchor, @NonNull Toast toast, int offset) {
        Rect displayFrame = new Rect();
        int[] screenLocation = new int[2];
        anchor.getWindowVisibleDisplayFrame(displayFrame);
        anchor.getLocationOnScreen(screenLocation);
        int anchorLeft = screenLocation[0];
        int anchorTop = Math.max(0, screenLocation[1] - DynamicUnitUtils.convertDpToPixels((float)32.0f));
        int minAnchorHeight = DynamicUnitUtils.convertDpToPixels((float)48.0f);
        int yOffset = DynamicUnitUtils.convertDpToPixels((float)offset);
        DisplayMetrics metrics = anchor.getResources().getDisplayMetrics();
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)metrics.widthPixels, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)metrics.heightPixels, (int)0);
        int toastWidth = DynamicUnitUtils.convertDpToPixels((float)48.0f);
        if (toast.getView() != null) {
            toast.getView().measure(widthMeasureSpec, heightMeasureSpec);
            toastWidth = toast.getView().getMeasuredWidth();
        }
        if (anchorTop < displayFrame.top + yOffset) {
            toast.setGravity(0x800033, anchorLeft + (anchor.getWidth() - toastWidth) / 2, anchorTop + Math.max(minAnchorHeight, anchor.getHeight()) + yOffset);
        } else {
            toast.setGravity(0x800033, anchorLeft + (anchor.getWidth() - toastWidth) / 2, anchorTop - Math.max(minAnchorHeight, anchor.getHeight()) - yOffset);
        }
        toast.show();
    }

    static /* synthetic */ Integer access$000() {
        return defaultBackgroundColor;
    }

    static /* synthetic */ Integer access$100() {
        return defaultTintColor;
    }

    static /* synthetic */ Integer access$200() {
        return errorBackgroundColor;
    }

    static /* synthetic */ Integer access$300() {
        return successBackgroundColor;
    }

    static /* synthetic */ Integer access$400() {
        return warningBackgroundColor;
    }

    static /* synthetic */ Drawable access$500() {
        return errorIcon;
    }

    static /* synthetic */ Drawable access$600() {
        return successIcon;
    }

    static /* synthetic */ Drawable access$700() {
        return warningIcon;
    }

    static /* synthetic */ boolean access$800() {
        return disableIcon;
    }

    static /* synthetic */ boolean access$900() {
        return tintIcon;
    }

    static /* synthetic */ int access$1000() {
        return iconSize;
    }

    static /* synthetic */ int access$1100() {
        return textSize;
    }

    public static class Config {
        private static Config sInstance;
        @ColorInt
        private Integer defaultBackgroundColor = DynamicHint.access$000();
        @ColorInt
        private Integer defaultTintColor = DynamicHint.access$100();
        @ColorInt
        private Integer errorBackgroundColor = DynamicHint.access$200();
        @ColorInt
        private Integer successBackgroundColor = DynamicHint.access$300();
        @ColorInt
        private Integer warningBackgroundColor = DynamicHint.access$400();
        private Drawable errorIcon = DynamicHint.access$500();
        private Drawable successIcon = DynamicHint.access$600();
        private Drawable warningIcon = DynamicHint.access$700();
        private boolean disableIcon = DynamicHint.access$800();
        private boolean tintIcon = DynamicHint.access$900();
        private int iconSize = DynamicHint.access$1000();
        @ColorInt
        private int textSize = DynamicHint.access$1100();
        private Typeface textTypeface = null;
        private Drawable toastBackground = null;

        private Config() {
        }

        @NonNull
        public static Config getInstance() {
            if (sInstance == null) {
                sInstance = new Config();
            }
            return sInstance;
        }

        @NonNull
        public Config setDefaultBackgroundColor(@Nullable @ColorInt Integer defaultBackgroundColor) {
            this.defaultBackgroundColor = defaultBackgroundColor;
            return this;
        }

        @NonNull
        public Config setDefaultTintColor(@Nullable @ColorInt Integer defaultTintColor) {
            this.defaultTintColor = defaultTintColor;
            return this;
        }

        @NonNull
        public Config setErrorBackgroundColor(@Nullable @ColorInt Integer errorBackgroundColor) {
            this.errorBackgroundColor = errorBackgroundColor;
            return this;
        }

        @NonNull
        public Config setSuccessBackgroundColor(@Nullable @ColorInt Integer successBackgroundColor) {
            this.successBackgroundColor = successBackgroundColor;
            return this;
        }

        @NonNull
        public Config setWarningBackgroundColor(@Nullable @ColorInt Integer warningBackgroundColor) {
            this.warningBackgroundColor = warningBackgroundColor;
            return this;
        }

        @NonNull
        public Config setErrorIcon(@Nullable Drawable errorIcon) {
            this.errorIcon = errorIcon;
            return this;
        }

        @NonNull
        public Config setSuccessIcon(@Nullable Drawable successIcon) {
            this.successIcon = successIcon;
            return this;
        }

        @NonNull
        public Config setWarningIcon(@Nullable Drawable warningIcon) {
            this.warningIcon = warningIcon;
            return this;
        }

        @NonNull
        public Config setDisableIcon(boolean disableIcon) {
            this.disableIcon = disableIcon;
            return this;
        }

        @NonNull
        public Config setTintIcon(boolean tintIcon) {
            this.tintIcon = tintIcon;
            return this;
        }

        @NonNull
        public Config setIconSize(int iconSize) {
            this.iconSize = iconSize;
            return this;
        }

        @NonNull
        public Config setTextSize(int textSize) {
            this.textSize = textSize;
            return this;
        }

        @NonNull
        public Config setTextTypeface(@Nullable Typeface textTypeface) {
            this.textTypeface = textTypeface;
            return this;
        }

        @NonNull
        public Config setToastBackground(@Nullable Drawable toastBackground) {
            this.toastBackground = toastBackground;
            return this;
        }

        public void apply() {
            defaultBackgroundColor = this.defaultBackgroundColor;
            defaultTintColor = this.defaultTintColor;
            errorBackgroundColor = this.errorBackgroundColor;
            successBackgroundColor = this.successBackgroundColor;
            warningBackgroundColor = this.warningBackgroundColor;
            errorIcon = this.errorIcon;
            successIcon = this.successIcon;
            warningIcon = this.warningIcon;
            disableIcon = this.disableIcon;
            tintIcon = this.tintIcon;
            iconSize = this.iconSize;
            textSize = this.textSize;
            textTypeface = this.textTypeface;
            toastBackground = this.toastBackground;
            sInstance = null;
        }

        public void reset() {
            defaultBackgroundColor = ADT_DEFAULT_BG_COLOR;
            defaultTintColor = ADT_DEFAULT_TINT_COLOR;
            errorBackgroundColor = ADT_DEFAULT_ERROR_BG_COLOR;
            successBackgroundColor = ADT_DEFAULT_SUCCESS_BG_COLOR;
            warningBackgroundColor = ADT_DEFAULT_WARNING_BG_COLOR;
            errorIcon = null;
            successIcon = null;
            warningIcon = null;
            disableIcon = false;
            tintIcon = true;
            iconSize = -1;
            textSize = -1;
            textTypeface = null;
            toastBackground = null;
            sInstance = null;
        }
    }
}

