/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.validators;

import com.plivo.api.exceptions.PlivoValidationException;
import com.plivo.api.util.Utils;
import com.plivo.api.validators.InRange;
import com.plivo.api.validators.MultiOf;
import com.plivo.api.validators.MultipleValidIntegers;
import com.plivo.api.validators.OneOf;
import com.plivo.api.validators.SubAccount;
import com.plivo.api.validators.UrlValues;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public class Validate {
    private static final Pattern urlPattern = Pattern.compile("(http[s]?://(?:[a-zA-Z]|[0-9]|[$-_@.&+]|[!*\\(\\),]|(?:%[0-9a-fA-F][0-9a-fA-F]))+|None)");
    private static final String COLON = ": ";

    private static Object fetchValue(Field field, Object request) {
        for (Method method : request.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase(field.getName()) || !field.getType().toString().equals(method.getReturnType().toString())) continue;
            try {
                return method.invoke(request, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static boolean isNotAmong(String[] options, String element, boolean caseSensitive) {
        for (String opt : options) {
            if (!caseSensitive && opt.equalsIgnoreCase(element)) {
                return false;
            }
            if (!opt.equals(element)) continue;
            return false;
        }
        return true;
    }

    private static String composeErrorMessage(String fieldName, String errorMessage) {
        return fieldName + COLON + errorMessage;
    }

    public static void check(Object request) throws PlivoValidationException {
        Field[] fields;
        for (Field field : fields = request.getClass().getDeclaredFields()) {
            Annotation[] annotations;
            Object value = Validate.fetchValue(field, request);
            if (value == null) continue;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (annotation instanceof InRange) {
                    int actualValue = (Integer)value;
                    if (((InRange)annotation).min() <= actualValue && ((InRange)annotation).max() >= actualValue) continue;
                    throw new PlivoValidationException(Validate.composeErrorMessage(field.getName(), ((InRange)annotation).message()));
                }
                if (annotation instanceof OneOf) {
                    String actualValue = (String)value;
                    if (!Validate.isNotAmong(((OneOf)annotation).options(), actualValue, ((OneOf)annotation).caseSensitive())) continue;
                    throw new PlivoValidationException(Validate.composeErrorMessage(field.getName(), ((OneOf)annotation).message()));
                }
                if (annotation instanceof UrlValues) {
                    String actualValue = (String)value;
                    if (urlPattern.matcher(actualValue).matches() || !Validate.isNotAmong(((UrlValues)annotation).options(), actualValue, ((UrlValues)annotation).caseSensitive())) continue;
                    throw new PlivoValidationException(Validate.composeErrorMessage(field.getName(), ((UrlValues)annotation).message()));
                }
                if (annotation instanceof MultiOf) {
                    String[] actualValue;
                    if (!(value instanceof String[])) continue;
                    for (String val : actualValue = (String[])value) {
                        if (!Validate.isNotAmong(((MultiOf)annotation).options(), val, ((MultiOf)annotation).caseSensitive())) continue;
                        throw new PlivoValidationException(Validate.composeErrorMessage(field.getName(), ((MultiOf)annotation).message()));
                    }
                    continue;
                }
                if (annotation instanceof SubAccount) {
                    String actualValue = (String)value;
                    if (Utils.isSubaccountIdValid(actualValue)) continue;
                    throw new PlivoValidationException(Validate.composeErrorMessage(field.getName(), ((SubAccount)annotation).message()));
                }
                if (!(annotation instanceof MultipleValidIntegers)) continue;
                if (value instanceof Integer) {
                    Integer actualValue = (Integer)value;
                    continue;
                }
                if (value instanceof String) {
                    String actualValue = (String)value;
                    String[] values = actualValue.split("<");
                    for (int i = 0; i < values.length; ++i) {
                        try {
                            Integer.parseInt(values[i]);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new PlivoValidationException(Validate.composeErrorMessage(field.getName(), ((MultipleValidIntegers)annotation).message()));
                        }
                    }
                    continue;
                }
                throw new PlivoValidationException(Validate.composeErrorMessage(field.getName(), ((MultipleValidIntegers)annotation).message()));
            }
        }
    }
}

