/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.powerpack;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.plivo.api.models.base.BaseResource;
import com.plivo.api.models.powerpack.BuyAddNumbers;
import com.plivo.api.models.powerpack.FindShortcode;
import com.plivo.api.models.powerpack.FindTollfree;
import com.plivo.api.models.powerpack.NumberPool;
import com.plivo.api.models.powerpack.NumberPriority;
import com.plivo.api.models.powerpack.PowerpackAddNumber;
import com.plivo.api.models.powerpack.PowerpackAddTollfree;
import com.plivo.api.models.powerpack.PowerpackCreator;
import com.plivo.api.models.powerpack.PowerpackDeleter;
import com.plivo.api.models.powerpack.PowerpackFindNumber;
import com.plivo.api.models.powerpack.PowerpackGetter;
import com.plivo.api.models.powerpack.PowerpackLister;
import com.plivo.api.models.powerpack.PowerpackNumberLister;
import com.plivo.api.models.powerpack.PowerpackUpdater;
import com.plivo.api.models.powerpack.RemoveNumber;
import com.plivo.api.models.powerpack.RemoveShortcode;
import com.plivo.api.models.powerpack.RemoveTollfree;
import com.plivo.api.models.powerpack.ShortcodeLister;
import com.plivo.api.models.powerpack.TollfreeLister;

public class Powerpack
extends BaseResource {
    private String createdOn;
    private String name;
    private String application_type;
    private String application_id;
    private Boolean sticky_sender;
    private Boolean local_connect;
    private String number_pool;
    private String uuid;
    public NumberPriority[] number_priority;
    @JsonIgnore
    public NumberPool numberpool;

    public static PowerpackCreator creator(String name) {
        return new PowerpackCreator(name);
    }

    public static PowerpackGetter getter(String id) {
        return new PowerpackGetter(id);
    }

    public static PowerpackLister lister() {
        return new PowerpackLister();
    }

    public PowerpackDeleter deleter() {
        return new PowerpackDeleter(this.getId());
    }

    public PowerpackUpdater updater() {
        return new PowerpackUpdater(this.getId());
    }

    public PowerpackNumberLister list_numbers() {
        return new PowerpackNumberLister(this.getNumberPoolId());
    }

    public PowerpackFindNumber find_number() {
        return new PowerpackFindNumber(this.getNumberPoolId());
    }

    public PowerpackAddNumber add_number() {
        return new PowerpackAddNumber(this.getNumberPoolId());
    }

    public PowerpackAddTollfree add_tollfree() {
        return new PowerpackAddTollfree(this.getNumberPoolId());
    }

    public FindShortcode find_shortcode() {
        return new FindShortcode(this.getNumberPoolId());
    }

    public FindTollfree find_tollfree() {
        return new FindTollfree(this.getNumberPoolId());
    }

    public ShortcodeLister list_shortcode() {
        return new ShortcodeLister(this.getNumberPoolId());
    }

    public TollfreeLister list_tollfree() {
        return new TollfreeLister(this.getNumberPoolId());
    }

    public RemoveNumber remove_number() {
        return new RemoveNumber(this.getNumberPoolId());
    }

    public RemoveShortcode remove_shortcode() {
        return new RemoveShortcode(this.getNumberPoolId());
    }

    public RemoveTollfree remove_tollfree() {
        return new RemoveTollfree(this.getNumberPoolId());
    }

    public PowerpackNumberLister count_numbers() {
        return new PowerpackNumberLister(this.getNumberPoolId());
    }

    public BuyAddNumbers buy_add_number() {
        return new BuyAddNumbers(this.getNumberPoolId());
    }

    public String getCreatedOn() {
        return this.createdOn;
    }

    public String getName() {
        return this.name;
    }

    public String getApplication_type() {
        return this.application_type;
    }

    public String getApplication_id() {
        return this.application_id;
    }

    public Boolean getSticky_sender() {
        return this.sticky_sender;
    }

    public Boolean getLocal_connect() {
        return this.local_connect;
    }

    public String getNumber_pool() {
        return this.number_pool;
    }

    public NumberPriority[] getNumber_priority() {
        return this.number_priority;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getId() {
        return this.getUuid();
    }

    public String getNumberPoolId() {
        String[] numberpool_uuid = this.getNumber_pool().split("/");
        return numberpool_uuid[5];
    }
}

