/*
 * Decompiled with CFR 0.152.
 */
package com.plivo.api.models.phlo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonParseException;
import com.plivo.api.Plivo;
import com.plivo.api.PlivoClient;
import com.plivo.api.exceptions.PlivoRestException;
import com.plivo.api.models.base.Updater;
import com.plivo.api.models.phlo.PhloUpdateResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Response;

public class PhloUpdater
extends Updater<PhloUpdateResponse> {
    private Map<String, Object> payload = new HashMap<String, Object>();
    @JsonIgnore
    protected PlivoClient plivoClient = Plivo.getPhloClient();

    public PhloUpdater(String phloId) {
        super(phloId);
    }

    public PhloUpdater payload(Map<String, Object> payload) {
        this.payload = payload;
        return this;
    }

    @Override
    public PlivoClient client() {
        return this.plivoClient;
    }

    public PhloUpdateResponse run() throws IOException, PlivoRestException {
        this.validate();
        try {
            Response response = this.obtainCall().execute();
            this.handleResponse(response);
            return (PhloUpdateResponse)response.body();
        }
        catch (JsonParseException je) {
            System.out.println("Improperly formed json received as response, ignoring!!");
            return null;
        }
    }

    @Override
    protected Call<PhloUpdateResponse> obtainCall() {
        return this.client().getApiService().runPhlo(this.client().getAuthId(), this.id, this.payload);
    }
}

